function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/kitPx/rc/ux/Bargraph
 */
define(['baja!', 'baja!bajaui:Orientation', 'lex!kitPx', 'bajaux/spandrel', 'underscore', 'nmodule/bajaui/rc/baja/Border', 'nmodule/gx/rc/baja/Brush', 'nmodule/gx/rc/baja/Font', 'css!nmodule/kitPx/rc/kitPx'], function (baja, types, lexs, spandrel, _, Border, Brush, Font) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      kitPxLex = _lexs[0];

  var range = _.range;
  var MIN_AUTO_TICKS = 4;
  var MAX_AUTO_TICKS = 10;
  var LOG10E = 0.4342944819018;

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-Bargraph',
        background: Brush.DEFAULT,
        fill: Brush.make('#666699'),
        foreground: Brush.make('black'),
        max: 100,
        min: 0,
        orientation: baja.$('bajaui:Orientation', 'vertical'),
        scale: 10,
        scaleFont: Font.NULL,
        scaleVisible: true,
        text: '',
        value: 0,
        valueFont: Font.NULL,
        valueVisible: true
      }
    };
  };
  /**
   * UxMedia implementation of `kitPx:Bargraph`.
   *
   * @class
   * @alias module:nmodule/kitPx/rc/ux/Bargraph
   * @extends module:bajaux/Widget
   */


  var BarGraph = /*#__PURE__*/function (_spandrel) {
    _inherits(BarGraph, _spandrel);

    var _super = _createSuper(BarGraph);

    function BarGraph(params) {
      _classCallCheck(this, BarGraph);

      return _super.call(this, {
        params: params,
        defaults: widgetDefaults()
      });
    }
    /**
     * Move the text outside of the bar if it doesn't fit.
     */


    _createClass(BarGraph, [{
      key: "doLayout",
      value: function doLayout() {
        var bar = this.jq().find('.-t-Bargraph-bar');

        if (!bar.length) {
          return;
        }

        var text = bar.children('.-t-Bargraph-text');
        var orientation = this.properties().getValue('orientation').getTag();
        var textBiggerThanBar = orientation === 'vertical' ? text.height() > bar.height() : text.width() > bar.width();
        text.toggleClass('-t-Bargraph-text-outside-bar', textBiggerThanBar);
      }
    }]);

    return BarGraph;
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties;
    var max = properties.max,
        min = properties.min,
        orientation = properties.orientation,
        scale = properties.scale,
        scaleVisible = properties.scaleVisible,
        text = properties.text,
        value = properties.value,
        valueVisible = properties.valueVisible;

    if (scale < 0) {
      scaleVisible = false;
    } else if (scale === 0) {
      scale = calcAutoScale(min, max);
    }

    var percent = clamp((value - min) / (max - min) * 100, 0, 100);
    var notchCount = scaleVisible ? Math.floor((max - min) / scale) : 0;
    var notchHeight = 100 / notchCount + '%';
    return Promise.all(range(0, notchCount).map(function (i) {
      return toNotchLabel(i, min, scale);
    })).then(function (notchLabels) {
      return spandrel.jsx("div", {
        className: "-t-Bargraph-wrapper -t-Bargraph-wrapper-".concat(orientation.getTag()),
        $init: initWrapper(properties)
      }, spandrel.jsx("div", {
        className: "-t-Bargraph-bar",
        style: {
          flexBasis: percent + '%'
        },
        $init: initBar(properties)
      }, spandrel.jsx("label", {
        className: "-t-Bargraph-text",
        style: {
          display: !valueVisible && 'none'
        },
        $init: initText(properties)
      }, text)), spandrel.jsx("div", {
        className: "-t-Bargraph-scale",
        style: {
          display: !scaleVisible && 'none'
        },
        $init: initScale(properties)
      }, notchLabels.map(function (notchLabel) {
        return spandrel.jsx("div", {
          className: "-t-Bargraph-scale-notch",
          style: {
            flexBasis: notchHeight
          }
        }, spandrel.jsx("div", {
          className: "-t-Bargraph-scale-notch-text"
        }, notchLabel), spandrel.jsx("div", {
          className: "-t-Bargraph-scale-notch-tick",
          $init: initNotchTick(properties)
        }));
      })));
    });
  }));

  function calcAutoScale(min, max) {
    var delta = max - min;
    var log10 = Math.log(delta) * LOG10E;
    var tickIncrement = Math.max(Math.pow(10, Math.trunc(log10)), Number.MIN_VALUE);
    var tickCount = Math.trunc(delta / tickIncrement); // at the completion of this block of code we are guaranteed
    // that (tickCount < MAX_TICKS) -- which is the primary goal.

    if (delta > 1) {
      if (tickCount < MIN_AUTO_TICKS) {
        tickIncrement /= 10.0;

        while (tickCount < MIN_AUTO_TICKS) {
          tickIncrement *= 2;
          tickCount = Math.trunc(delta / tickIncrement) + 1;
        } // squeeze


        while (tickCount > MAX_AUTO_TICKS) {
          tickIncrement *= 2;
          tickCount = Math.trunc(delta / tickIncrement) + 1;
        }
      }
    } else {
      // <= 1.0
      if (tickCount < MIN_AUTO_TICKS) {
        tickIncrement /= 10.0;

        while (tickCount < MIN_AUTO_TICKS) {
          tickIncrement /= 2;
          tickCount = Math.trunc(delta / tickIncrement) + 1;
        } // squeeze


        while (tickCount > MAX_AUTO_TICKS) {
          tickIncrement *= 2;
          tickCount = Math.trunc(delta / tickIncrement) + 1;
        }
      }
    }

    return tickIncrement;
  }

  function calcPrecision(scale) {
    var precision = 1;

    while (scale < 1) {
      scale *= 10;
      ++precision;
    }

    return precision;
  }

  function clamp(value, min, max) {
    return Math.min(Math.max(min, value), max);
  }
  /** style the filled bar portion of the graph */


  function initBar(_ref2) {
    var fill = _ref2.fill;
    return function (el) {
      return fill.applyBackgroundToElement(el);
    };
  }
  /** style the "tick" at each notch in the scale display */


  function initNotchTick(_ref3) {
    var foreground = _ref3.foreground;
    return function (el) {
      return foreground.applyBackgroundToElement(el);
    };
  }
  /** style the scale display which contains the ticks and tick labels */


  function initScale(_ref4) {
    var foreground = _ref4.foreground,
        scaleFont = _ref4.scaleFont;

    if (scaleFont.equivalent(Font.NULL)) {
      scaleFont = Font.make(kitPxLex.get('bargraph.scale.font'));
    }

    return function (el) {
      foreground.applyForegroundToElement(el);
      scaleFont.applyToElement(el);
    };
  }
  /** style the text display of the current value */


  function initText(_ref5) {
    var foreground = _ref5.foreground,
        valueFont = _ref5.valueFont;

    if (valueFont.equivalent(Font.NULL)) {
      valueFont = Font.make(kitPxLex.get('bargraph.value.font'));
    }

    return function (el) {
      valueFont.applyToElement(el);
      foreground.applyForegroundToElement(el);
    };
  }
  /** style the background */


  function initWrapper(_ref6) {
    var background = _ref6.background,
        foreground = _ref6.foreground;
    return function (el) {
      Border.make({
        width: 1,
        style: Border.SOLID,
        brush: foreground
      }).applyToElement(el);
      background.applyBackgroundToElement(el);
    };
  }

  function toNotchLabel(i, min, scale) {
    return i ? (min + i * scale).toString({
      precision: calcPrecision(scale),
      trimTrailingZeros: true
    }) : '';
  }

  return BarGraph;
});
