function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/**
 * API Status: **Private**
 * @module nmodule/kitPx/rc/SetPointEditor
 */
define(['bajaux/mixin/subscriberMixIn', 'bajaux/Properties', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'baja!'], function (subscriberMixIn, Properties, CompositeEditor, CompositeBuilder, baja) {
  'use strict';

  var INNER_EDITOR = 'innerEditor',
      keys = [INNER_EDITOR];
  /**
   * Bajaux Editor for SetPointEditor which only works with HxSetPointFE to call the set
   * action on a ControlPoint when any modified changes to the editor occur and the
   * save is invoked.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/config/CompositeBuilder
   * @alias module:nmodule/kitPx/rc/SetPointEditor
   */

  var SetPointEditor = function SetPointEditor() {
    var that = this;
    CompositeEditor.apply(that, arguments);
    subscriberMixIn(that);
  }; //extend and set up prototype chain


  SetPointEditor.prototype = Object.create(CompositeEditor.prototype);
  SetPointEditor.prototype.constructor = SetPointEditor;
  /**
   * Creates a span element for the inner editor.
   * @param {Object} dom
   * @returns {Promise}
   */

  SetPointEditor.prototype.doInitialize = function (dom) {
    dom.html('<span class="js-' + INNER_EDITOR + '"/>');
    return CompositeEditor.prototype.doInitialize.apply(this, arguments);
  };
  /**
   * Load the value into an inner editor. When a ControlPoint is loaded,
   * subscribe to 'out' slot and provide any changes to the userif the
   * Editor is not modified.
   * @param {baja.Value} value
   * @param loadParams The Object literal for load params
   * @returns {Promise}
   */


  SetPointEditor.prototype.doLoad = function (value, loadParams) {
    var that = this;
    return CompositeEditor.prototype.doLoad.apply(this, arguments).then(function () {
      if (loadParams && loadParams.complexOrd && !loadParams.slot) {
        //SetPointFieldEditor subscribes to the complex Ord and updates on any changes to out when the slot is empty
        return baja.Ord.make(loadParams.complexOrd).get({
          lease: true
        }).then(function (comp) {
          that.getSubscriber().attach("changed", function (prop) {
            if (prop.getName() === "out" && !that.isModified()) {
              return that.getBuilder().getEditorFor(INNER_EDITOR).load(comp.get(prop).getValue());
            }
          });
          return that.getSubscriber().subscribe(comp).then(function () {
            if (!that.isModified()) {
              //this accounts for any changes to the out value that occur between when the HxSetPointEditor is loaded and the subscription starts.
              return that.getBuilder().getEditorFor(INNER_EDITOR).load(comp.get("out").getValue());
            }
          });
        });
      }
    });
  };
  /**
   *  Read the result of the inner Widget.read(). If the value happens to be a
   *  'baja:StatusValue' then ensure to make the status {ok} just like bajaui does.
   *  @returns {baja.Value}
   */


  SetPointEditor.prototype.doRead = function () {
    var that = this;
    return this.getBuilder().readAll().then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
          result = _ref2[0];

      if (that.value().getType().is("baja:StatusValue")) {
        var statusValue = that.value().newCopy();
        statusValue.setStatus(baja.Status.ok);
        statusValue.setValue(result);
        return statusValue;
      }

      return result;
    });
  };
  /**
   * Provide a copy of the value in to the inner editor. If the value is a
   * 'baja:StatusValue' then only send down the value. Transfer all properties
   * except the 'uxFieldEditor'.
   * @returns {module:nmodule/webEditors/rc/fe/config/CompositeBuilder}
   */


  SetPointEditor.prototype.makeBuilder = function () {
    var that = this,
        builder = new CompositeBuilder(),
        properties = that.properties().clone();
    properties.remove("uxFieldEditor");

    builder.getDomFor = function (key) {
      return that.jq().children('.js-' + key);
    };

    builder.getKeys = function () {
      return keys.slice();
    };

    builder.getValueFor = function (key) {
      if (key === INNER_EDITOR) {
        if (that.value().getType().is("baja:StatusValue")) {
          //SetPointFieldEditor only shows the value and not status even if the
          //binding ord is for a StatusValue.
          return that.value().getValue().newCopy();
        } else {
          return that.value().newCopy();
        }
      }
    };

    builder.getConfigFor = function (key) {
      if (key === INNER_EDITOR) {
        return {
          formFactor: that.getFormFactor(),
          properties: properties
        };
      }
    };

    return builder;
  };

  return SetPointEditor;
});
