function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitPx/rc/binding/SpectrumBinding
 */
define(['baja!', 'nmodule/bajaui/rc/baja/binding/Binding', 'nmodule/gx/rc/baja/Color', 'nmodule/gx/rc/util/colorUtils'], function (baja, Binding, Color, colorUtils) {
  'use strict';

  var interpolateColors = colorUtils.interpolateColors;
  /**
   * BajaScript implementation of a `kitPx:SpectrumBinding`.
   * @class
   * @alias module:nmodule/kitPx/rc/binding/SpectrumBinding
   * @extends module:nmodule/bajaui/rc/baja/binding/Binding
   */

  return /*#__PURE__*/function (_Binding) {
    _inherits(SpectrumBinding, _Binding);

    var _super = _createSuper(SpectrumBinding);

    function SpectrumBinding() {
      _classCallCheck(this, SpectrumBinding);

      return _super.apply(this, arguments);
    }

    _createClass(SpectrumBinding, [{
      key: "provide",

      /**
       * If the requested property equals the `widgetProperty` property of this
       * binding and it is bound to a `baja:INumeric`, then this will provide a
       * `Brush` or `Color` (depending on the bound property), interpolated
       * between `lowColor`/`midColor`/`highColor` based on the bound object's
       * current numeric value.
       *
       * @param {string} prop
       * @returns {baja.Simple|null}
       */
      value: function provide(prop) {
        var widget = this.getWidget();
        var widgetProp = widget && widget.properties().getValue(prop);
        var numeric = this.isBound() && this.getOrdTarget().getObject();

        if (prop !== this.get('widgetProperty') || !isColorOrBrush(widgetProp) || !isINumeric(numeric)) {
          return _get(_getPrototypeOf(SpectrumBinding.prototype), "provide", this).call(this, prop);
        }

        var number = baja.Double.getNumberFromINumeric(numeric);
        var color = this.$solveColor(number);
        return isColor(widgetProp) ? color : baja.$('gx:Brush', color.encodeToString());
      }
      /**
       * @private
       * @param {number} value - current bound numeric value
       * @returns {module:nmodule/gx/rc/baja/Color}
       */

    }, {
      key: "$solveColor",
      value: function $solveColor(value) {
        var delta = this.get('extent') / 2;
        var setpoint = this.get('setpoint');
        var lowColor, highColor, bottom, top;

        if (value < setpoint) {
          lowColor = this.get('lowColor');
          highColor = this.get('midColor');
          bottom = setpoint - delta;
          top = setpoint;
        } else {
          lowColor = this.get('midColor');
          highColor = this.get('highColor');
          bottom = setpoint;
          top = setpoint + delta;
        }

        return solveColor(value, lowColor, highColor, bottom, top);
      }
    }]);

    return SpectrumBinding;
  }(Binding);
  /**
   * @param {number} value - current bound numeric value
   * @param {module:nmodule/gx/rc/baja/Color} lowColor
   * @param {module:nmodule/gx/rc/baja/Color} highColor
   * @param {number} bottom - bottom of range
   * @param {number} top - top of range
   * @returns {module:nmodule/gx/rc/baja/Color}
   */

  function solveColor(value, lowColor, highColor, bottom, top) {
    var ratio = (value - bottom) / (top - bottom);
    return Color.make(interpolateColors(lowColor.getRgba(), highColor.getRgba(), ratio));
  }

  function isColor(val) {
    return baja.hasType(val, 'gx:Color');
  }

  function isBrush(val) {
    return baja.hasType(val, 'gx:Brush');
  }

  function isColorOrBrush(val) {
    return isColor(val) || isBrush(val);
  }

  function isINumeric(val) {
    return baja.hasType(val, 'baja:INumeric');
  }
});
