function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/* jshint browser: true */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/kitPx/rc/binding/PopupBinding
 */
define(['baja!', 'baja!gx:Size,gx:Point', 'nmodule/bajaui/rc/baja/binding/Binding', 'nmodule/webEditors/rc/wb/profile/profileUtils', 'log!uxMedia', 'css!nmodule/kitPx/rc/kitPx'], function (baja, types, Binding, profileUtils, log) {
  'use strict';

  var logFine = log.fine.bind(log),
      logWarning = log.warning.bind(log),
      logSevere = log.severe.bind(log);
  var modalPopups = {};
  /**
   * BajaScript implementation of a `kitPx:PopupBinding`.
   * @class
   * @alias module:nmodule/kitPx/rc/binding/PopupBinding
   * @extends module:nmodule/bajaui/rc/baja/binding/Binding
   */

  return /*#__PURE__*/function (_Binding) {
    _inherits(PopupBinding, _Binding);

    var _super = _createSuper(PopupBinding);

    function PopupBinding() {
      _classCallCheck(this, PopupBinding);

      return _super.apply(this, arguments);
    }

    _createClass(PopupBinding, [{
      key: "addListeners",

      /**
       * Add event listeners for the widget:
       *
       * - on click, popup
       * - add CSS to indicate cursor
       *
       * @param {module:bajaux/Widget} widget
       */
      value: function addListeners(widget) {
        var _this = this;

        this.addWidgetEvents(widget, {
          click: function click(e) {
            var ord = _this.get('ord');

            if (ord.isNull()) {
              return;
            }

            var ordTarget = _this.getOrdTarget();

            if (ordTarget && ordTarget.ord) {
              var viewQuery = profileUtils.getViewQuery(ord); //Avoid the `optimizedOrd` ord stored in the ord property in favor of the original ord which is usually more human-readable.
              //Optimized ords for components can handle ords and the user is more likely to want to see the original slot ord that they entered.

              ord = ordTarget.ord;

              if (viewQuery) {
                ord = baja.Ord.make({
                  base: ord,
                  child: viewQuery
                });
              }
            }

            var url = ord.toUri();

            _this.popup({
              url: url,
              popupWidth: _this.get('size').getWidth(),
              popupHeight: _this.get('size').getHeight(),
              popupX: _this.get('position').x(),
              popupY: _this.get('position').y(),
              external: isExternal(ord),
              modal: _this.get('modal'),
              title: _this.get('title')
            })["catch"](logSevere);
          },
          initialized: function initialized() {
            var ord = _this.get('ord');

            widget.jq().addClass('ux-PopupBinding').toggleClass('popup-target', !ord.isNull());
          },
          destroyed: function destroyed() {
            widget.jq().removeClass('ux-PopupBinding popup-target');

            _this.$cleanupClosedModalPopups();
          }
        });
      }
      /**
       * Open a popup to the specified dimensions and position. If dimension information is not provided, will default
       * to 90% of screen size. Make sure to set external=true for links to non-niagara websites like https://www.google.com.
       * If the link is not external, fullScreen=true will be added to the view parameters to ensure that the HxProfile chrome
       * is not present in the popup.
       * @param {Object} [obj] the Object Literal for the method's arguments.
       * @param {String} obj.url
       * @param {Number} [obj.popupWidth]
       * @param {Number} [obj.popupHeight]
       * @param {Number} [obj.popupX]
       * @param {Number} [obj.popupY]
       * @param {Boolean} [obj.external] If true, will not add the fullScreen=true view parameter to the url.
       * @param {Boolean} [obj.modal] If true, the current pop-up can only be opened one at a time.
       * @param {String} [obj.title] If provided, the initial title on the pop-up can be set,
       * @return {Promise.<boolean>} resolves to true if a new window was opened.
       */

    }, {
      key: "popup",
      value: function popup(obj) {
        var _this2 = this;

        return window.niagara.env.toHyperlink(obj.url).then(function (hyperlinkUrl) {
          var popupX = obj.popupX,
              popupY = obj.popupY,
              popupWidth = obj.popupWidth,
              popupHeight = obj.popupHeight,
              external = obj.external,
              modal = obj.modal,
              title = obj.title;
          var url = hyperlinkUrl;

          if (popupWidth === undefined) {
            var factor = 0.9;
            popupWidth = Math.floor(screen.width * factor);
            popupHeight = Math.floor(screen.height * factor);
            popupX = (screen.width - popupWidth) / 2;
            popupY = (screen.height - popupHeight) / 8; //allow extra space for toolbar and status bar
          }

          var fullUrl = url + (external ? "" : "|view:?fullScreen=true");
          var win,
              specs = "resizable=yes, " + "location=no, " + "scrollbars=yes, " + "status=no, " + "toolbar=no, " + "left=" + popupX + ", " + "top=" + popupY + ", " + "width=" + popupWidth + ", " + "height=" + popupHeight;
          var pop = modalPopups[fullUrl];

          if (pop && !pop.closed && isValidLocation(pop)) {
            //if pop-up is modal then focus original one instead of opening a new one
            pop.focus();
            return false;
          }

          win = window.open(fullUrl, 'fullScreen' + new Date().getTime(), specs, false);

          if (win) {
            setLoadedTitle(win, title);
          } else {
            logWarning("Pop-ups must be enabled...");
            return false;
          }

          _this2.$cleanupClosedModalPopups();

          if (modal) {
            modalPopups[fullUrl] = win;
          }

          return true;
        });
      }
      /**
       * cleanup the closed modal dialogs
       */

    }, {
      key: "$cleanupClosedModalPopups",
      value: function $cleanupClosedModalPopups() {
        Object.keys(modalPopups).forEach(function (name) {
          var oldPop = modalPopups[name];

          if (oldPop && oldPop.closed) {
            //references to closed modal dialogs are no longer required
            delete modalPopups[name];
          }
        });
      }
      /**
       * cleanup all modal dialogs
       */

    }, {
      key: "$cleanupAllModalPopups",
      value: function $cleanupAllModalPopups() {
        modalPopups = {};
      }
    }]);

    return PopupBinding;
  }(Binding);
  /**
   * Attempt to set the popup window title after it has loaded, but this doesn't prevent the window from changing its title after load.
   *
   * @param {DOMWindow} popupWindow
   * @param {String} [title]
   * @return {boolean}
   */

  function setLoadedTitle(popupWindow, title) {
    if (!title) {
      return;
    }

    try {
      popupWindow.addEventListener('load', function () {
        formatTitle(title).then(function (titleFormat) {
          if (titleFormat) {
            popupWindow.document.title = titleFormat;
          }
        })["catch"](logFine);
      });
    } catch (err) {
      //if an error is provided, its likely that the page title cannot be set because of its a cross-origin frame.
      logFine(err);
    }

    return true;
  }
  /**
   * For better localization support, treat the title as a BFormat. If any error is presented, fallback to original string behavior.
   * @param {String} [title]
   * @return {Promise<string>}
   */


  function formatTitle(title) {
    return baja.Format.format({
      pattern: title
    }).then(function (titleFormat) {
      if (!titleFormat || titleFormat.indexOf('%err:') > -1) {
        return title;
      }

      return titleFormat;
    })["catch"](function (e) {
      logFine(e);
      return title;
    });
  }

  function isValidLocation(popupWindow) {
    try {
      return popupWindow.location && popupWindow.location.href;
    } catch (err) {
      //if an error is provided, its likely that the page is still open and the site
      //prevents a cross-origin frame. When the page is closed, there should be no error
      logFine(err);
    }

    return true;
  }
  /**
   * Determine if the Ord is External or not.
   * @param {baja.Ord} ord
   * @return {boolean}
   */


  function isExternal(ord) {
    var queries = baja.Ord.make(ord).parse(),
        i,
        external = false;

    for (i = 0; i < queries.size(); ++i) {
      if (queries.get(i).getSchemeName() === "http" || queries.get(i).getSchemeName() === "https") {
        external = true;
      } else if (external && queries.get(i).getSchemeName() === "view") {
        var params = queries.get(i).getParameters();

        if (params['external'] === 'false') {
          external = false;
        }
      }
    }

    return external;
  }
});
