function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/**
 * API Status: **Private**
 * @module nmodule/kitPx/rc/binding/ButtonGroupBinding
 */
define(['baja!', 'lex!baja', 'bajaux/Widget', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/bajaui/rc/baja/binding/Binding', 'nmodule/bajaui/rc/model/BindingList', 'nmodule/bajaui/rc/model/UxModel', 'nmodule/bajaui/rc/ux/bajauiEvents', 'nmodule/bajaui/rc/ux/RadioButton', 'nmodule/bajaui/rc/ux/ToggleButton', 'nmodule/kitPx/rc/utils/kitPxUtils', 'nmodule/webEditors/rc/fe/baja/util/rangeUtils', 'log!nmodule.kitPx.rc.binding.ButtonGroupBinding', 'css!nmodule/kitPx/rc/kitPx'], function (baja, lexs, Widget, _, asyncUtils, Binding, BindingList, UxModel, bajauiEvents, RadioButton, ToggleButton, kitPxUtils, rangeUtils, log) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var bajaLex = lexs[0];
  var ACTION_PERFORMED_EVENT = bajauiEvents.ACTION_PERFORMED_EVENT;
  /**
   * BajaScript implementation of a `kitPx:ButtonGroupBinding`.
   * @class
   * @alias module:nmodule/kitPx/rc/binding/ButtonGroupBinding
   * @extends module:nmodule/bajaui/rc/baja/binding/Binding
   */

  var ButtonGroupBinding = /*#__PURE__*/function (_Binding) {
    _inherits(ButtonGroupBinding, _Binding);

    var _super = _createSuper(ButtonGroupBinding);

    function ButtonGroupBinding() {
      _classCallCheck(this, ButtonGroupBinding);

      return _super.apply(this, arguments);
    }

    _createClass(ButtonGroupBinding, [{
      key: "targetChanged",

      /**
       * Updates the bound widget if target has changed.
       *
       * @returns {Promise}
       */
      value: function targetChanged() {
        if (!this.isBound()) {
          return Promise.resolve();
        }

        var widget = this.getWidget();
        var model = widget.value();

        if (!model) {
          return Promise.resolve();
        }

        if (model && model.getKids().length === 0) {
          return this.$resolveKids().then(function (kids) {
            var modelParams = {
              bindings: model.getBindingList().getBindings(),
              name: model.getName(),
              type: model.getType(),
              properties: model.getProperties(),
              kids: kids
            };
            return UxModel.make(modelParams).then(function (newModel) {
              return widget.load(newModel);
            });
          });
        } else {
          var target = this.getOrdTarget();
          var obj = target.getObject();
          var kidDom = widget.jq().find(".ux-ToggleButton").filter(function () {
            return Widget["in"](this) instanceof ToggleButton; //skip spandrel inner Widgets that have the same class at ToggleButton
          });

          if (!kidDom.length) {
            return Promise.resolve();
          }

          var value = obj.getOut().getValue();

          if (baja.hasType(obj, 'control:BooleanWritable')) {
            var trueWidget = Widget["in"](kidDom[0]);
            var falseWidget = Widget["in"](kidDom[1]);
            trueWidget.properties().setValue("selected", value);
            falseWidget.properties().setValue("selected", !value);
          } else if (baja.hasType(obj, 'control:EnumWritable')) {
            var range = getRange(obj);

            _.map(range.getOrdinals(), function (ordinal, index) {
              var toggleWidget = Widget["in"](kidDom[index]);
              toggleWidget.properties().setValue("selected", value.getOrdinal() === ordinal);
            });
          }
        }
      }
      /**
       * Generate the information to build the child widgets.
       * @return {Promise}
       */

    }, {
      key: "$resolveKids",
      value: function $resolveKids() {
        var _this = this;

        var target = this.getOrdTarget();
        var obj = target.getObject();
        var type = this.get('style').getTag() === "radio" ? RadioButton : ToggleButton;

        if (baja.hasType(obj, 'control:BooleanWritable')) {
          var isTrue = obj.getOut().getValue();
          return resolveTrueFalseText(obj.get('facets')).then(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
                trueText = _ref2[0],
                falseText = _ref2[1];

            var trueBinding = new ActionPerformedBinding(_this, true);
            var falseBinding = new ActionPerformedBinding(_this, false);
            return [{
              type: type,
              properties: {
                text: trueText,
                selected: isTrue,
                keepSelected: true
              },
              bindings: [trueBinding]
            }, {
              type: type,
              properties: {
                text: falseText,
                selected: !isTrue,
                keepSelected: true
              },
              bindings: [falseBinding]
            }];
          });
        } else if (baja.hasType(obj, 'control:EnumWritable')) {
          var enums = obj.getOut().getValue();
          var range = getRange(obj);
          return resolveDisplayNames(range).then(function (displayNames) {
            return _.map(displayNames, function (displayName, index) {
              var tagIndex = range.getOrdinals()[index];
              var selected = enums.getOrdinal() === tagIndex;
              var value = baja.DynamicEnum.make({
                ordinal: tagIndex,
                range: range
              });
              var binding = new ActionPerformedBinding(_this, value);
              return {
                type: type,
                properties: {
                  text: displayName,
                  selected: selected,
                  unselectable: true
                },
                bindings: [binding]
              };
            });
          });
        } else {
          logSevere("Unknown type:" + obj.getType());
          return Promise.resolve();
        }
      }
    }]);

    return ButtonGroupBinding;
  }(Binding);
  /**
   * @inner
   * @param {baja.Component} enumWritable a `control:EnumWritable` instance
   * @return {baja.EnumRange}
   */


  function getRange(enumWritable) {
    var enums = enumWritable.getOut().getValue();
    var facets = enumWritable.get('facets');
    var range = enums.getRange();

    if (facets) {
      var facetsRange = facets.get('range');

      if (facetsRange) {
        range = facetsRange;
      }
    }

    return range;
  }
  /*
   * @inner
   * @param {baja.EnumRange} range
   * @return {Promise.<String>}
   */


  function resolveDisplayNames(range) {
    return Promise.all(_.map(range.getOrdinals(), function (o) {
      return rangeUtils.getEnumRangeDisplay(o, range);
    }));
  }
  /**
   * Compute the true/false display text to use from the `trueText` /
   * `falseText` facets.
   *
   * @inner
   * @returns {Promise} promise to be resolved with an array containing two
   * strings for trueText/falseText
   */


  function resolveTrueFalseText(facets) {
    var trueText = facets.get('trueText', bajaLex.get('true')),
        falseText = facets.get('falseText', bajaLex.get('false'));
    return Promise.all([doFormat(trueText), doFormat(falseText)]);
  }
  /**
   * @inner
   * @returns {Promise}
   */


  function doFormat(pattern) {
    return baja.Format.format({
      pattern: pattern
    });
  }
  /**
   * @private
   * @class
   * @extends module:nmodule/bajaui/rc/baja/binding/Binding
   * @memberOf module:nmodule/kitPx/rc/binding/ButtonGroupBinding
   * @param {module:nmodule/kitPx/rc/binding/ButtonGroupBinding} mainBinding
   * @param {baja.Value} value
   */


  var ActionPerformedBinding = /*#__PURE__*/function (_Binding2) {
    _inherits(ActionPerformedBinding, _Binding2);

    var _super2 = _createSuper(ActionPerformedBinding);

    function ActionPerformedBinding(mainBinding, value) {
      var _this2;

      _classCallCheck(this, ActionPerformedBinding);

      _this2 = _super2.call(this);
      _this2.$mainBinding = mainBinding;
      _this2.$value = value; //Workaround for https://acsjira.honeywell.com/browse/NCCB-47402

      _this2.add({
        slot: 'ord',
        value: baja.Ord.DEFAULT
      });

      _this2.add({
        slot: 'degradeBehavior',
        value: baja.$('bajaui:DegradeBehavior')
      });

      return _this2;
    }

    _createClass(ActionPerformedBinding, [{
      key: "addListeners",
      value: function addListeners(widget) {
        var _this3 = this;

        this.addWidgetEvents(widget, _defineProperty({}, ACTION_PERFORMED_EVENT, function () {
          var ordTarget = _this3.$mainBinding.getOrdTarget();

          var component = ordTarget.getComponent();
          return component.invoke({
            slot: 'set',
            value: _this3.$value
          }).then(function () {
            //give the station a few seconds to complete the change. Call `targetChange` to potentially deselect the newly selected value if
            //there was another higher priority input slot that prevented the value change from changing value.
            asyncUtils.waitInterval(2000).then(function () {
              return _this3.$mainBinding.targetChanged();
            })["catch"](logSevere);
          });
        }));
      }
    }]);

    return ActionPerformedBinding;
  }(Binding);

  return ButtonGroupBinding;
});
