function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitPx/rc/binding/BoundLabelBinding
 */
define(['baja!', 'baja!kitPx:StatusEffect', 'nmodule/bajaui/rc/baja/binding/ValueBinding', 'nmodule/gx/rc/baja/Brush', 'nmodule/webEditors/rc/wb/mgr/componentStatusUtils'], function (baja, types, ValueBinding, Brush, componentStatusUtils) {
  'use strict';

  var getBackground = componentStatusUtils.getBackground,
      getForeground = componentStatusUtils.getForeground;
  /**
   * BajaScript implementation of `kitPx:BoundLabelBinding`.
   * @class
   * @alias module:nmodule/kitPx/rc/binding/BoundLabelBinding
   * @extends module:nmodule/bajaui/rc/baja/binding/ValueBinding
   */

  return /*#__PURE__*/function (_ValueBinding) {
    _inherits(BoundLabelBinding, _ValueBinding);

    var _super = _createSuper(BoundLabelBinding);

    function BoundLabelBinding() {
      _classCallCheck(this, BoundLabelBinding);

      return _super.apply(this, arguments);
    }

    _createClass(BoundLabelBinding, [{
      key: "provide",

      /**
       * If the bound point is an instance of `baja:IStatus` and effects enabled,
       * provides the following overrides:
       *
       * - `blink`: is the point in unackedAlarm status?
       * - `foreground`: the foreground color for the status configured in the lexicon
       * - `background`: the background color for the status configured in the lexicon
       * - `border`: special border behavior for `baja:StatusBoolean`s
       *
       * @param {string} name
       * @param {object} [cx]
       */
      value: function provide(name, cx) {
        var ordTarget = this.isBound() && this.getOrdTarget();
        var obj = ordTarget && ordTarget.getObject();
        var statusEffect = this.get('statusEffect').getTag();

        if (!ordTarget || !baja.hasType(obj, 'baja:IStatus') || statusEffect === 'none') {
          return _get(_getPrototypeOf(BoundLabelBinding.prototype), "provide", this).apply(this, arguments);
        }

        var status = baja.Status.getStatusFromIStatus(obj);

        switch (name) {
          case 'blink':
            if (status.isUnackedAlarm() && statusEffect === 'colorAndBlink') {
              return true;
            }

            break;

          case 'foreground':
            var fg = getForeground(status);

            if (fg) {
              return Brush.make(fg);
            }

            break;

          case 'background':
            var bg = getBackground(status);

            if (bg) {
              return Brush.make(bg);
            }

            break;

          case 'border':
            if (!baja.hasType(obj, 'baja:StatusBoolean')) {
              break;
            }

            var converter = this.get(name);

            if (baja.hasType(converter, 'converters:FixedSimple')) {
              return converter.get('value');
            }

            if (baja.hasType(converter, 'converters:PassThrough')) {
              return converter.convert(obj, this.getWidget().properties().getValue(name));
            }

            if (baja.hasType(converter, 'converters:INumericToSimple')) {
              var map = converter.get('map');
              var num = obj.get('value') ? getHighest(map) : getLowest(map);
              return map.get(num);
            }

            break;
        }

        return _get(_getPrototypeOf(BoundLabelBinding.prototype), "provide", this).apply(this, arguments);
      }
    }]);

    return BoundLabelBinding;
  }(ValueBinding);

  function getHighest(map) {
    return Math.max.apply(Math, _toConsumableArray(map.getMaximums()));
  }

  function getLowest(map) {
    return Math.min.apply(Math, _toConsumableArray(map.getMinimums()));
  }
});
