function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/**
 * API Status: **Private**
 * @module nmodule/kitPx/rc/binding/ActionBinding
 */
define(['baja!', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/bajaui/rc/baja/binding/Binding', 'nmodule/webEditors/rc/fe/feDialogs', 'log!uxMedia', 'css!nmodule/kitPx/rc/kitPx'], function (baja, switchboard, Binding, feDialogs, log) {
  'use strict';

  var logSevere = log.severe.bind(log);
  /**
   * Resolve the action argument.
   * If actionArg is the value is '', then resolve to undefined.
   * If actionArg is already a non-string Value, then resolve to it.
   * If actionArg is a string and getActionParameterDefault resolves to a Simple, decode it.
   *
   * @param {baja.Component} component
   * @param {baja.Slot}slot
   * @param {baja.Value|String} actionArg
   * @return {Promise}
   */

  function resolveActionArgument(component, slot, actionArg) {
    var paramType;

    if (actionArg === '') {
      return Promise.resolve();
    }

    if (!actionArg.getType().is("baja:String")) {
      return Promise.resolve(actionArg);
    }

    return component.getActionParameterDefault(slot).then(function (value) {
      paramType = value.getType();

      if (paramType.isSimple()) {
        return value.decodeFromString(actionArg);
      } else {
        logSevere("ActionBinding arg type mismatch " + actionArg.getType() + " != " + paramType);
      }
    })["catch"](function () {
      logSevere("ActionBinding parsing arg \"" + actionArg + "\" as \"" + paramType + "\"");
    });
  }
  /**
   * BajaScript implementation of a `kitPx:ActionBinding`.
   * @class
   * @alias module:nmodule/kitPx/rc/binding/ActionBinding
   * @extends module:nmodule/bajaui/rc/baja/binding/Binding
   */


  return /*#__PURE__*/function (_Binding) {
    _inherits(ActionBinding, _Binding);

    var _super = _createSuper(ActionBinding);

    function ActionBinding() {
      var _this;

      _classCallCheck(this, ActionBinding);

      _this = _super.apply(this, arguments);
      switchboard(_assertThisInitialized(_this), {
        invokeActionOnTarget: {
          allow: 'oneAtATime',
          onRepeat: 'returnLast'
        }
      });
      return _this;
    }
    /**
     * Add event listeners for the widget:
     *
     * - on mousedown when not a right click, fire action when widgetEvent is `actionPerformed`
     * - on mouseenter, fire action when widgetEvent is `mouseEvent`
     * - on focus, fire action when widgetEvent is `focusEvent`
     * - on initialized, fire action when widgetEvent is `started`
     *
     * @param {module:bajaux/Widget} widget
     */


    _createClass(ActionBinding, [{
      key: "addListeners",
      value: function addListeners(widget) {
        var _this2 = this;

        this.addWidgetEvents(widget, {
          mouseenter: function mouseenter() {
            var widgetEvent = _this2.get('widgetEvent');

            if (widgetEvent === "mouseEvent") {
              return _this2.invokeActionOnTarget();
            }
          },
          mousedown: function mousedown(event) {
            if (event && event.button === 2) {
              return;
            }

            var widgetEvent = _this2.get('widgetEvent');

            if (widgetEvent === "actionPerformed") {
              return _this2.invokeActionOnTarget();
            }
          },
          initialized: function initialized() {
            var widgetEvent = _this2.get('widgetEvent');

            if (widgetEvent === "focusEvent") {
              var jq = widget.jq();

              if (jq.length > 0) {
                var dom = jq[0]; //focus events do not bubble so a native event listener is used

                var focusHandler = function focusHandler() {
                  _this2.invokeActionOnTarget()["catch"](logSevere);
                };

                _this2.$focusHandler = focusHandler;
                dom.addEventListener('focus', focusHandler, true);
              }
            }

            if (widgetEvent === "started") {
              return _this2.invokeActionOnTarget();
            }
          },
          destroyed: function destroyed() {
            var jq = widget.jq();

            if (jq.length > 0) {
              jq[0].removeEventListener('focus', _this2.$focusHandler, true);
            }

            delete _this2.$focusHandler;
          }
        });
      }
      /**
       * Invoke the action on the Target
       * @return {Promise}
       */

    }, {
      key: "invokeActionOnTarget",
      value: function invokeActionOnTarget() {
        var ord = this.get('ord');

        if (ord.isNull()) {
          return Promise.resolve();
        }

        if (!this.isBound()) {
          logSevere("ActionBinding not bound to component " + ord);
          return Promise.resolve();
        }

        var actionArg = this.get('actionArg');
        var component = this.getOrdTarget().getComponent();
        var slot = this.getOrdTarget().getSlotInComponent();

        if (slot && slot.isAction()) {
          return resolveActionArgument(component, slot, actionArg).then(function (actionArgument) {
            return feDialogs.action({
              component: component,
              slot: slot,
              actionArgument: actionArgument
            });
          });
        } else {
          logSevere("ActionBinding not bound to action " + ord);
        }

        return Promise.resolve();
      }
    }]);

    return ActionBinding;
  }(Binding);
});
