/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module coll
 * @private
 */
define(["bajaScript/sys",
        "bajaScript/baja/coll/collUtil",
        "bajaScript/baja/coll/QueryCursor", 
        "bajaScript/baja/coll/tableMixIn",
        "bajaScript/baja/coll/Table",
        "bajaScript/baja/coll/TableCursor",
        "bajaScript/baja/coll/QueryResult"], function (
        baja,
        collUtil,
        QueryCursor,
        tableMixIn,
        Table,
        TableCursor,
        QueryResult) {
  
  "use strict";
  
  var registerType = baja.registerType,
      BaseBajaObj = baja.BaseBajaObj,
      /**
       * BajaScript Collection Namespace.
       * @namespace baja.coll 
       */
      coll = baja.coll = new BaseBajaObj();
    
  coll.Table = Table;
  coll.QueryResult = QueryResult;

  registerType("box:BoxTable", function () { return Table; });
  registerType("box:BoxQueryResult", function () { return QueryResult; });

  return baja;
});