/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @module baja/tag/Tag
 */
define(["bajaScript/sys",
        "bajaScript/baja/tag/Id"], function (
        baja,
        Id) {
  
  "use strict";
     
  /**
   * A Tag is an immutable Id and Data Value pair.
   *
   * @class
   * @alias module:baja/tag/Tag
   *
   * @param {String} qname The Id qname for the tag.
   * @param [value] The value for the Tag. If not specified, 
   * the Tag is regarded as a Marker Tag.
   */  
  var Tag = function Tag(qname, value) {
    var that = this;

    that.$id = new Id(qname);
    that.$value = arguments.length === 1 ? baja.Marker.DEFAULT : value;
  };

  /**
   * @returns {module:baja/tag/Id} The tag's Id.
   */
  Tag.prototype.getId = function() {
    return this.$id;
  };

  /**
   * @returns The tag's value.
   */
  Tag.prototype.getValue = function() {
    return this.$value;
  };

  /**
   * @param  o The value used for comparison.
   * 
   * @returns {Boolean} Returns true if the Tag is equal to this one.
   */
  Tag.prototype.equals = function(o) {
    return !!(o && o instanceof Tag &&
              o.$id.equals(this.$id) && o.$value.equals(this.$value));
  };

  return Tag;
});