/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

define([], function () {
  "use strict";
  
  /**
   * The base class for all BajaScript Objects.
   * 
   * @class
   * @alias baja.BaseBajaObj
   */
  var BaseBajaObj = function BaseBajaObj() {};
  
  /**
   * Indicates whether some other object is equal to this one.
   *
   * @param {Object} obj the reference object with which to compare.
   *
   * @returns {Boolean} true if this object is the same as the obj argument; false otherwise.
   */
  BaseBajaObj.prototype.equals = function (obj) {
    return this === obj;
  };

  /**
   * Return the inner value of the object.
   * 
   * By default the object's instance is returned.
   *
   * @returns {*} the inner value of the object or just the object's instance.
   */
  BaseBajaObj.prototype.valueOf = function () {
    return this;
  };
  
  return BaseBajaObj;
});