/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/**
 * Defines {@link baja.StatusValue}.
 * @module baja/obj/StatusValue
 */
define([
  "bajaScript/sys",
  "bajaScript/baja/comp/Struct",
  "bajaPromises" ], function (
  baja,
  Struct,
  Promise) {
  
  "use strict";
  
  var subclass = baja.subclass,
      callSuper = baja.callSuper;

  function getStatusValueString(valueStr, statusStr) {
    return valueStr + " " + statusStr;
  }

  /**
   * Represents a `baja:StatusValue` in BajaScript.
   *
   * @alias baja.StatusValue
   * @extends baja.Struct
   */
  var StatusValue = function StatusValue() {
    callSuper(StatusValue, this, arguments);
  };
  
  subclass(StatusValue, Struct);

  /**
   * Returns a promise that resolves with the string value of the `StatusValue`
   *
   * @param {Object} [cx] a context object passed to status / value toString
   * @param {Object} [cx.lex] a `baja` Lexicon value
   * @returns {Promise.<string>|string}
   */
  StatusValue.prototype.toString = function (cx) {
    var status = this.get('status'),
      value = this.getValue();

    if (!cx) {
      var valueStr = status.isNull() ? "-" : value.toString();
      return getStatusValueString(valueStr, status.toString());
    }

    return Promise.all([
      status.isNull() ? "-" : value.toString(cx),
      status.toString(cx)
    ]).then(function (results) {
      return getStatusValueString(results[0], results[1]);
    });
  };

  return StatusValue;
});
