/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * Defines {@link baja.Singleton}.
 * @module baja/obj/Singleton
 */
define(["bajaScript/sys",
        "bajaScript/baja/obj/Object"], 
        function (baja, BObject) {
  
  'use strict';
  
  var subclass = baja.subclass,
      callSuper = baja.callSuper;
  
  /**
   * Represents `baja:Singleton` in BajaScript.
   * 
   * Since this Constructor represents an abstract class, it should never
   * be directly used to create a new Object.
   *
   * @class
   * @alias baja.Singleton
   * @extends baja.Object
   */
  var Singleton = function Singleton() {
    callSuper(Singleton, this, arguments); 
  };
  
  subclass(Singleton, BObject);
  
  return Singleton;
});