/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * Defines {@link baja.Property}.
 * @module baja/comp/Property
 */
define(["bajaScript/sys",
        "bajaScript/baja/comp/Slot"], function (
         baja,
         Slot) {
  "use strict";
  
  var subclass = baja.subclass,
      callSuper = baja.callSuper;
  
  /**
   * Property Slot.
   * 
   * `Property` defines a `Slot` which is a storage location
   * for a variable in a `Complex`.
   * 
   * A new object should never be directly created with this Constructor. All Slots are 
   * created internally by BajaScript.
   *
   * @class
   * @alias baja.Property
   * @extends baja.Slot
   */ 
  var Property = function Property(slotName, displayName) {  
    callSuper(Property, this, arguments);
  };
  
  subclass(Property, Slot);
    
  /**
   * Is this Slot a Property? Yes.
   *
   * @returns {Boolean}
   */
  Property.prototype.isProperty = function () {
    return true;
  };

  /**
   * Get the Type of this Property slot. Override depending on whether this
   * is a frozen or dynamic property.
   * 
   * @abstract
   * @function
   * @name getType
   * @memberOf baja.Property#
   * @returns {Type}
   */
  
  return Property;
});