/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/* eslint-disable camelcase */
/* global niagara_wb_util_getHostOrd: false */

/**
 * Defines {@link baja.LocalHost}.
 * @module baja/comp/LocalHost
 */
define([
  "bajaScript/nav",
  "bajaScript/baja/comp/Host" ], function (
    baja,
    Host) {
  
  "use strict";
  
  var subclass = baja.subclass,
      callSuper = baja.callSuper,
      NAV_NAME = "localhost",
      ICON = "module://icons/x16/localhost.png",
      ORD = "local:";
  
  /**
   * Represents a `baja:LocalHost` in BajaScript.
   *
   * @class
   * @alias baja.LocalHost
   * @extends baja.Host
   */  
  var LocalHost = function LocalHost() {
    callSuper(LocalHost, this, [ { navName: NAV_NAME, icon: ICON, ord: ORD } ]);
  };
  
  subclass(LocalHost, Host);

  /**
   * Get the Host for the local session. The nav ord will always be `local:`
   * when not session-aware. If running in Workbench, then Java-JS interop may
   * indicate that the BOX session is to an external IP; in that case the
   * session-aware nav ord may be an `ip:` ord.
   *
   * @private
   * @returns {baja.LocalHost}
   */
  LocalHost.$getLocalSessionHost = function () {
    var sessionOrd;

    if (typeof niagara_wb_util_getHostOrd === 'function') {
      sessionOrd = baja.Ord.make(niagara_wb_util_getHostOrd()).normalize();
    } else {
      sessionOrd = "local:";
    }

    var localhost = new LocalHost();
    localhost.$update({ navName: NAV_NAME, icon: ICON, ord: ORD, sessionOrd: sessionOrd });
    return localhost;
  };
  
  return LocalHost;
});
