/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @private
 * @module baja/comp/Host
 */
define([
  'bajaScript/nav',
  'bajaScript/baja/comp/Host' ], function (
    baja,
    Host) {

  'use strict';

  /**
   * Represents a `baja:IpHost` in BajaScript.
   *
   * @private
   * @class
   * @param {string} hostname
   */
  var IpHost = function IpHost(hostname) {
    Host.call(this, { navName: hostname, ord: 'ip:' + hostname });
  };
  IpHost.prototype = Object.create(Host.prototype);
  IpHost.prototype.constructor = IpHost;

  return IpHost;
});
