/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/*jslint white: true */
/*global define */

/**
 * @module baja/boxcs/RemoveOp
 * @private
 */
define(["bajaScript/comm",
        "bajaScript/baja/boxcs/SyncOp"], 
        function (baja, SyncOp) {
  
  "use strict";
  
  var subclass = baja.subclass,
      callSuper = baja.callSuper;
  
  /**
   * @class Remove SyncOp.
   *
   * @name RemoveOp
   * @extends SyncOp
   * @inner
   * @private
   *
   * @param comp the Component the remove is happening upon.
   * @param {baja.Slot} slot the Slot to remove from the Component.
   */ 
  function RemoveOp(comp, slot) {
    callSuper(RemoveOp, this, arguments);

    // Encode argument to a data structure
    var a = {
      nm: this.getId(),
      h: comp.getHandle(),
      n: slot.getName()
    };
    
    this.$arg = a;  
  }
  
  subclass(RemoveOp, SyncOp); 
  
  RemoveOp.id = "v";
  
  /**
   * Decode and commit the SyncOp.
   *
   * @name RemoveOp.decodeAndCommit
   * @function
   * @private
   *
   * @param comp the Component the remove is happening on.
   * @param sp the syncOp data structure to be decoded.
   */
  RemoveOp.decodeAndCommit = function (comp, sp) {  
    if (comp !== null) {  
      var name = sp.n,
          slot = comp.getSlot(name);
      
      if (slot !== null) {
        comp.remove({
          "slot": slot, 
          "cx": { commit: true, serverDecode: true }
        });
      }
    }
  };
  
  return RemoveOp;
});