function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Rowyn Brunner
 */

/**
 * API Status: **Private**
 * @module nmodule/gx/rc/fe/SizeEditor
 */
define(['baja!', 'hbs!nmodule/gx/rc/fe/template/SizeEditor', 'lex!gx', 'bajaux/events', 'bajaux/Widget', 'Promise', 'underscore', 'nmodule/gx/rc/baja/Size', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/fe', 'css!nmodule/gx/rc/gx'], function (baja, tplSizeEditor, lexes, events, Widget, Promise, _, Size, BaseEditor, fe) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT;

  var _lexes = _slicedToArray(lexes, 1),
      gxLex = _lexes[0];
  /**
   * Bajaux editor for BSize.
   *
   * Consists of two field editors, one for width and one for height, defaulting to value 0. The editors are readonly.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/gx/rc/fe/SizeEditor
   */


  var SizeEditor = /*#__PURE__*/function (_BaseEditor) {
    _inherits(SizeEditor, _BaseEditor);

    var _super = _createSuper(SizeEditor);

    function SizeEditor(params) {
      _classCallCheck(this, SizeEditor);

      return _super.call(this, _.extend({
        keyName: 'SizeEditor',
        moduleName: 'gx'
      }, {}, params));
    }
    /**
     * Creates an editor with correctly labeled width and height editors.
     *
     * @param {JQuery} dom
     * @returns {Promise}
     */


    _createClass(SizeEditor, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this = this;

        var widthText = gxLex.get('size.width');
        var heightText = gxLex.get('size.height');
        dom.html(tplSizeEditor({
          widthText: widthText,
          heightText: heightText
        }));
        dom.on(MODIFY_EVENT, '.type-baja-Number', function () {
          _this.setModified(true);

          return false;
        });
        return Promise.all([fe.buildFor({
          formFactor: 'mini',
          dom: dom.find('.width-editor'),
          value: 0
        }), fe.buildFor({
          formFactor: 'mini',
          dom: dom.find('.height-editor'),
          value: 0
        })]);
      }
      /**
       * Loads the width field of the size parameter into the width editor, and the height field of the size parameter into
       * the height editor.
       *
       * @param {module:nmodule/gx/rc/baja/Size} size
       * @returns {Promise}
       */

    }, {
      key: "doLoad",
      value: function doLoad(size) {
        return Promise.all([this.$getWidthEditor().load(size.getWidth()), this.$getHeightEditor().load(size.getHeight())]);
      }
      /**
       * Returns the values of the width and height editors in a Size field.
       *
       * @returns {Promise.<module:nmodule/gx/rc/baja/Size>}
       */

    }, {
      key: "doRead",
      value: function doRead() {
        return Promise.all([this.$getWidthEditor().read(), this.$getHeightEditor().read()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
              width = _ref2[0],
              height = _ref2[1];

          return new Size(width, height);
        });
      }
      /**
       * Sets all the child widgets of this editor to readonly.
       *
       * @param {boolean} readonly
       * @returns {Promise}
       */

    }, {
      key: "doReadonly",
      value: function doReadonly(readonly) {
        return this.getChildWidgets().setAllReadonly(readonly);
      }
      /**
       * Sets all the child widgets of this editor to enabled.
       *
       * @param {boolean} enabled
       * @returns {Promise}
       */

    }, {
      key: "doEnabled",
      value: function doEnabled(enabled) {
        return this.getChildWidgets().setAllEnabled(enabled);
      }
      /**
       * Destroys all children of the editor.
       *
       * @returns {Promise}
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        return this.getChildWidgets().destroyAll();
      }
      /**
       * @private
       * @returns {module:bajaux/Widget}
       */

    }, {
      key: "$getWidthEditor",
      value: function $getWidthEditor() {
        return Widget["in"](this.jq().find('.width-editor'));
      }
      /**
       * @private
       * @returns {module:bajaux/Widget}
       */

    }, {
      key: "$getHeightEditor",
      value: function $getHeightEditor() {
        return Widget["in"](this.jq().find('.height-editor'));
      }
    }]);

    return SizeEditor;
  }(BaseEditor);

  return SizeEditor;
});
