function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module  module:nmodule/gx/rc/fe/PenEditor
 */
define(['baja!', 'jquery', 'Promise', 'bajaux/Widget', 'bajaux/events', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/gx/rc/baja/Pen', 'lex!gx'], function (baja, $, Promise, Widget, events, fe, BaseEditor, OrderedMapEditor, Pen, lexs) {
  "use strict";

  var _lexs = _slicedToArray(lexs, 1),
      lex = _lexs[0];

  var dotted = [2, 2];
  var dashed = [8, 2];
  /**
   * Baja UX field editor for Pen.
   * Has an editor each for the pen width, cap, join and dash pattern
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/gx/rc/fe/PenEditor
   */

  var PenEditor = /*#__PURE__*/function (_BaseEditor) {
    _inherits(PenEditor, _BaseEditor);

    var _super = _createSuper(PenEditor);

    function PenEditor() {
      _classCallCheck(this, PenEditor);

      return _super.apply(this, arguments);
    }

    _createClass(PenEditor, [{
      key: "doInitialize",

      /**
       * Creates a pen editor with child editors for width, cap, join and pen dash pattern width default
       * values as 1, Pen.CAP_BUTT, Pen.JOIN_MITER and Pen.noDash respectively.
       *
       * @param {JQuery} dom
       * @returns {Promise}
       */
      value: function doInitialize(dom) {
        var _this = this;

        dom.html("<span class=\"width\"/>\n                <span class=\"dash\"/> \n                <span class=\"cap\"/> \n                <span class=\"join\"/>");
        dom.on(events.MODIFY_EVENT, '.type-baja-Number, .width, .dash, .cap, .join', function () {
          _this.setModified(true);

          return false;
        });
        var defaultPen = Pen.DEFAULT;
        this.validators().add(function (pen) {
          var width = pen.getWidth();

          if (width === Number.POSITIVE_INFINITY || width === Number.NEGATIVE_INFINITY || isNaN(width)) {
            throw new Error(lex.get("pen.width.error", width.encodeToString()));
          }
        });
        return Promise.all([fe.buildFor({
          dom: this.$getWidthElement(),
          value: defaultPen.getWidth(),
          formFactor: 'mini'
        }), fe.buildFor({
          dom: this.$getDashElement(),
          value: this.$getDashPatternMap(),
          loadParams: {
            selectedValue: 'solid'
          },
          type: OrderedMapEditor,
          formFactor: 'mini'
        }), fe.buildFor({
          dom: this.$getCapElement(),
          value: this.$getPenCapMap(),
          loadParams: {
            selectedValue: defaultPen.getCap()
          },
          type: OrderedMapEditor,
          formFactor: 'mini'
        }), fe.buildFor({
          dom: this.$getJoinElement(),
          value: this.$getPenJoinMap(),
          loadParams: {
            selectedValue: defaultPen.getJoin()
          },
          type: OrderedMapEditor,
          formFactor: 'mini'
        })]);
      }
      /**
       * Loads the width value, cap and join styles and dash pattern in to the respective editors
       *
       * @param {module:nmodule/gx/rc/baja/Pen} pen
       * @returns {Promise}
       */

    }, {
      key: "doLoad",
      value: function doLoad(pen) {
        return Promise.join(this.$getWidthEditor().load(pen.getWidth()), this.$getDashEditor().setSelectedValue(this.$getDashPatternString(pen.getDash()), true), this.$getCapEditor().setSelectedValue(pen.getCap(), true), this.$getJoinEditor().setSelectedValue(pen.getJoin(), true));
      }
      /**
       * Reads the value of width, pen cap & join and dash pattern, forms a Pen instance and
       * returns it
       *
       * @returns {module:nmodule/gx/rc/baja/Pen}
       */

    }, {
      key: "doRead",
      value: function doRead() {
        var _this2 = this;

        return Promise.all([this.$getWidthEditor().read(), this.$getDashEditor().read(), this.$getCapEditor().read(), this.$getJoinEditor().read()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 4),
              width = _ref2[0],
              dash = _ref2[1],
              cap = _ref2[2],
              join = _ref2[3];

          return Pen.make(width, cap, join, _this2.$getDashPatternValue(dash));
        });
      }
      /**
       * Sets all the child widgets of this editor to readonly.
       *
       * @param {boolean} readonly
       * @returns {Promise}
       */

    }, {
      key: "doReadonly",
      value: function doReadonly(readonly) {
        return this.getChildWidgets().setAllReadonly(readonly);
      }
      /**
       * Sets all the child widgets of this editor to enabled.
       *
       * @param {boolean} enabled
       * @returns {Promise}
       */

    }, {
      key: "doEnabled",
      value: function doEnabled(enabled) {
        return this.getChildWidgets().setAllEnabled(enabled);
      }
      /**
       * Destroys all children of the editor.
       *
       * @returns {Promise}
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        return this.getChildWidgets().destroyAll();
      }
      /**
       * @private
       * @returns {bajaux/Widget}
       */

    }, {
      key: "$getWidthEditor",
      value: function $getWidthEditor() {
        return Widget["in"](this.$getWidthElement());
      }
      /**
       * @private
       * @returns {bajaux/Widget}
       */

    }, {
      key: "$getCapEditor",
      value: function $getCapEditor() {
        return Widget["in"](this.$getCapElement());
      }
      /**
       * @private
       * @returns {bajaux/Widget}
       */

    }, {
      key: "$getJoinEditor",
      value: function $getJoinEditor() {
        return Widget["in"](this.$getJoinElement());
      }
      /**
       * @private
       * @returns {bajaux/Widget}
       */

    }, {
      key: "$getDashEditor",
      value: function $getDashEditor() {
        return Widget["in"](this.$getDashElement());
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getWidthElement",
      value: function $getWidthElement() {
        return this.jq().find('.width');
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getCapElement",
      value: function $getCapElement() {
        return this.jq().find('.cap');
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getJoinElement",
      value: function $getJoinElement() {
        return this.jq().find('.join');
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getDashElement",
      value: function $getDashElement() {
        return this.jq().find('.dash');
      }
      /**
       * Returns the OrderedMap of pen cap options to be loaded in to the Pen Cap
       *
       * editor.
       * @private
       * @returns {baja.OrderedMap}
       */

    }, {
      key: "$getPenCapMap",
      value: function $getPenCapMap() {
        var _this3 = this;

        var penCaps = [Pen.CAP_BUTT, Pen.CAP_SQUARE, Pen.CAP_ROUND],
            map = new baja.OrderedMap();
        penCaps.forEach(function (cap) {
          map.put(_this3.$getCapDisplay(cap), cap);
        });
        return map;
      }
      /**
       * Returns the OrderedMap of pen join options to be loaded in to the Pen Join
       * editor.
       *
       * @private
       * @returns {baja.OrderedMap}
       */

    }, {
      key: "$getPenJoinMap",
      value: function $getPenJoinMap() {
        var _this4 = this;

        var penJoins = [Pen.JOIN_MITER, Pen.JOIN_BEVEL, Pen.JOIN_ROUND],
            map = new baja.OrderedMap();
        penJoins.forEach(function (join) {
          map.put(_this4.$getJoinDisplay(join), join);
        });
        return map;
      }
      /**
       * Returns the OrderedMap of pen dash pattern options to be loaded in to the Pen Dash
       * editor.
       *
       * @private
       * @returns {baja.OrderedMap}
       */

    }, {
      key: "$getDashPatternMap",
      value: function $getDashPatternMap() {
        var map = new baja.OrderedMap();
        map.put(lex.get('pen.dash.solid'), 'solid');
        map.put(lex.get('pen.dash.dotted'), 'dotted');
        map.put(lex.get('pen.dash.dashed'), 'dashed');
        return map;
      }
      /**
       * Get the display name for the options in pen cap
       *
       * @private
       * @param {number} cap
       * @returns {string}
       */

    }, {
      key: "$getCapDisplay",
      value: function $getCapDisplay(cap) {
        var capDisplay = '';

        switch (cap) {
          case Pen.CAP_BUTT:
            capDisplay = lex.get("pen.cap.butt");
            break;

          case Pen.CAP_SQUARE:
            capDisplay = lex.get("pen.cap.square");
            break;

          case Pen.CAP_ROUND:
            capDisplay = lex.get("pen.cap.round");
            break;

          default:
            throw new Error('Invalid cap');
        }

        return capDisplay;
      }
      /**
       * Get the display name for the options in pen join
       *
       * @private
       * @param {number} join
       * @returns {string}
       */

    }, {
      key: "$getJoinDisplay",
      value: function $getJoinDisplay(join) {
        var joinDisplay = '';

        switch (join) {
          case Pen.JOIN_MITER:
            joinDisplay = lex.get("pen.join.miter");
            break;

          case Pen.JOIN_BEVEL:
            joinDisplay = lex.get("pen.join.bevel");
            break;

          case Pen.JOIN_ROUND:
            joinDisplay = lex.get("pen.join.round");
            break;

          default:
            throw new Error('Invalid join');
        }

        return joinDisplay;
      }
      /**
       * Get the dash pattern value as array (solid = PenEditor.solid; dotted = PenEditor.dotted; dashed = PenEditor.dashed)
       *
       * @private
       * @returns {Array.<number>}
       */

    }, {
      key: "$getDashPatternValue",
      value: function $getDashPatternValue(dashStr) {
        var dashArr = Pen.noDash;

        switch (dashStr) {
          case 'solid':
            return dashArr.slice();

          case 'dotted':
            return dotted.slice();

          case 'dashed':
            return dashed.slice();
        }

        return dashArr;
      }
      /**
       * Get the dash pattern string (solid/dotted/dashed)
       *
       * @private
       * @returns {string}
       */

    }, {
      key: "$getDashPatternString",
      value: function $getDashPatternString(dash) {
        var dashPatternStr;

        if (dash.length === 0) {
          dashPatternStr = 'solid';
        } else if (dash[0] === dotted[0] && dash[1] === dotted[1]) {
          dashPatternStr = 'dotted';
        } else if (dash[0] === dashed[0] && dash[1] === dashed[1]) {
          dashPatternStr = 'dashed';
        } else {
          throw new Error(lex.get('pen.dash.custom.error'));
        }

        return dashPatternStr;
      }
    }]);

    return PenEditor;
  }(BaseEditor);

  return PenEditor;
});
