function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/**
 * API Status: **Private**
 * @module module:nmodule/gx/rc/fe/InsetsEditor
 */
define(['baja!', 'lex!gx', 'bajaux/events', 'bajaux/Widget', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/fe', 'nmodule/gx/rc/baja/Insets', 'css!nmodule/gx/rc/gx'], function (baja, lexs, events, Widget, Promise, _, BaseEditor, fe, Insets) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      gxLex = _lexs[0];

  var topLabel = gxLex.get('insets.top'),
      rightLabel = gxLex.get('insets.right'),
      bottomLabel = gxLex.get('insets.bottom'),
      leftLabel = gxLex.get('insets.left');

  var insetsEditorHtml = function insetsEditorHtml() {
    return "\n    <span class='top'></span>\n    <span class='right'></span>\n    <span class='bottom'></span>\n    <span class='left'></span>\n  ";
  };
  /**
   * Insets Editor is a Baja Ux field editor which stores offsets from the four sides of a rectangle.
   * Top ,right, bottom and left are the four offsets that can be provided in their respective editors
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/gx/rc/fe/InsetsEditor
   */


  var InsetsEditor = /*#__PURE__*/function (_BaseEditor) {
    _inherits(InsetsEditor, _BaseEditor);

    var _super = _createSuper(InsetsEditor);

    function InsetsEditor() {
      _classCallCheck(this, InsetsEditor);

      return _super.apply(this, arguments);
    }

    _createClass(InsetsEditor, [{
      key: "doInitialize",

      /**
       * Initializes the top,right,bottom and left insetEditors with value 0
       *
       * @param  {JQuery} dom
       * @returns {Promise}
       */
      value: function doInitialize(dom) {
        var _this = this;

        dom.addClass('InsetsEditor');
        dom.html(insetsEditorHtml());
        dom.on(events.MODIFY_EVENT, '.type-baja-Number', function () {
          _this.setModified(true);

          return false;
        });
        var insetEditors = [fe.buildFor({
          dom: this.$getTopElement(),
          value: 0,
          properties: {
            prelabel: topLabel
          },
          formFactor: 'mini'
        }), fe.buildFor({
          dom: this.$getRightElement(),
          value: 0,
          properties: {
            prelabel: rightLabel
          },
          formFactor: 'mini'
        }), fe.buildFor({
          dom: this.$getBottomElement(),
          value: 0,
          properties: {
            prelabel: bottomLabel
          },
          formFactor: 'mini'
        }), fe.buildFor({
          dom: this.$getLeftElement(),
          value: 0,
          properties: {
            prelabel: leftLabel
          },
          formFactor: 'mini'
        })];
        return Promise.all(insetEditors);
      }
      /**
       * Loads the top, right, bottom and left values in to the respective editors
       * It checks for the invalid values.
       * Invalid entries include NaN, +inf, -inf, string values or any special characters
       * @param {module:nmodule/gx/rc/baja/Insets} insets
       * @returns {Promise}
       */

    }, {
      key: "doLoad",
      value: function doLoad(insets) {
        var top = insets.getTop(),
            right = insets.getRight(),
            bottom = insets.getBottom(),
            left = insets.getLeft();

        if (isInvalidEntry(top) || isInvalidEntry(right) || isInvalidEntry(bottom) || isInvalidEntry(left)) {
          top = right = bottom = left = 0;
        }

        return Promise.all([this.$getTopEditor().load(top), this.$getRightEditor().load(right), this.$getBottomEditor().load(bottom), this.$getLeftEditor().load(left)]);
      }
      /**
       * Reads the value of top ,right, bottom and left, forms an Inset instance and returns it
       * If an invalid entry is made, Insets are set to 0
       * Invalid entries include NaN, +inf, -inf, string values or any special characters
       * @returns {module:nmodule/gx/rc/baja/Insets}
       */

    }, {
      key: "doRead",
      value: function doRead() {
        var topEditor = this.$getTopEditor(),
            rightEditor = this.$getRightEditor(),
            bottomEditor = this.$getBottomEditor(),
            leftEditor = this.$getLeftEditor();
        return Promise.all([topEditor.read(), rightEditor.read(), bottomEditor.read(), leftEditor.read()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 4),
              top = _ref2[0],
              right = _ref2[1],
              bottom = _ref2[2],
              left = _ref2[3];

          if (isInvalidEntry(top) || isInvalidEntry(right) || isInvalidEntry(bottom) || isInvalidEntry(left)) {
            return Insets.make(0);
          }

          return Insets.make(top, right, bottom, left);
        });
      }
      /**
       * Sets all the child widgets of this editor to readonly.
       *
       * @param {boolean} readonly
       * @returns {Promise}
       */

    }, {
      key: "doReadonly",
      value: function doReadonly(readonly) {
        return this.getChildWidgets().setAllReadonly(readonly);
      }
      /**
       * Sets all the child widgets of this editor to enabled.
       *
       * @param {boolean} enabled
       * @returns {Promise}
       */

    }, {
      key: "doEnabled",
      value: function doEnabled(enabled) {
        return this.getChildWidgets().setAllEnabled(enabled);
      }
      /**
       * Destroys all children of the editor.
       *
       * @returns {Promise}
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        return this.getChildWidgets().destroyAll();
      }
      /**
       * @private
       * @returns {module:bajaux/Widget}
       */

    }, {
      key: "$getTopEditor",
      value: function $getTopEditor() {
        return Widget["in"](this.$getTopElement());
      }
      /**
       * @private
       * @returns {module:bajaux/Widget}
       */

    }, {
      key: "$getRightEditor",
      value: function $getRightEditor() {
        return Widget["in"](this.$getRightElement());
      }
      /**
       * @private
       * @returns {module:bajaux/Widget}
       */

    }, {
      key: "$getBottomEditor",
      value: function $getBottomEditor() {
        return Widget["in"](this.$getBottomElement());
      }
      /**
       * @private
       * @returns {module:bajaux/Widget}
       */

    }, {
      key: "$getLeftEditor",
      value: function $getLeftEditor() {
        return Widget["in"](this.$getLeftElement());
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getTopElement",
      value: function $getTopElement() {
        return this.jq().find('.top');
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getRightElement",
      value: function $getRightElement() {
        return this.jq().find('.right');
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getBottomElement",
      value: function $getBottomElement() {
        return this.jq().find('.bottom');
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getLeftElement",
      value: function $getLeftElement() {
        return this.jq().find('.left');
      }
    }]);

    return InsetsEditor;
  }(BaseEditor);

  function isNumber(number) {
    return typeof number === 'number';
  }

  function isInvalidEntry(side) {
    return side === Number.POSITIVE_INFINITY || side === Number.NEGATIVE_INFINITY || isNaN(side) || !isNumber(side);
  }

  return InsetsEditor;
});
