function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Rowyn Brunner
 */

/**
 * API Status: **Private**
 * @module nmodule/gx/rc/baja/Size
 */
define(['baja!'], function (baja) {
  'use strict';
  /**
   * BajaScript representation of a `BSize`
   *
   * @class
   * @alias module:nmodule/gx/rc/baja/Size
   * @extends baja.Simple
   */

  var Size = /*#__PURE__*/function (_baja$Simple) {
    _inherits(Size, _baja$Simple);

    var _super = _createSuper(Size);

    /**
     * Constructs a Size with the given width and height. Will throw an error if width or height is not a numeric type.
     * Not a number, positive infinite, and negative infinite values are accepted.
     *
     * @param {number} width
     * @param {number} height
     */
    function Size(width, height) {
      var _this;

      _classCallCheck(this, Size);

      _this = _super.call(this);

      if (!isNumber(width)) {
        throw new Error('Width must be a number.');
      }

      if (!isNumber(height)) {
        throw new Error('Height must be a number.');
      }

      _this.$width = width;
      _this.$height = height;
      return _this;
    } // noinspection JSMethodCanBeStatic

    /**
     * Constructs a Size with the given width and height; this is an instance method.
     *
     * @param {number} width
     * @param {number} height
     * @returns {module:nmodule/gx/rc/baja/Size}
     */


    _createClass(Size, [{
      key: "make",
      value: function make(width, height) {
        return Size.make(width, height);
      }
      /**
       * Constructs a Size with the given width and height.
       *
       * @param {number} width
       * @param {number} height
       * @returns {module:nmodule/gx/rc/baja/Size}
       */

    }, {
      key: "getWidth",

      /**
       * Gets the width of the Size
       *
       * @returns {number}
       */
      value: function getWidth() {
        return this.$width;
      }
      /**
       * Gets the height of the Size
       *
       * @returns {number}
       */

    }, {
      key: "getHeight",
      value: function getHeight() {
        return this.$height;
      }
      /**
       * Encodes the Size to the "width,height" format. If the Size is the null value, returns "null"
       *
       * @returns {string}
       */

    }, {
      key: "encodeToString",
      value: function encodeToString() {
        if (this === Size.NULL) {
          return 'null';
        }

        var stringWidth = this.$width.encodeToString();
        var stringHeight = this.$height.encodeToString();
        return "".concat(stringWidth, ",").concat(stringHeight);
      } // noinspection JSMethodCanBeStatic

      /**
       * Converts a string value into a Size tuple. Throws an error if the string is not in the valid format
       * "width,height".
       *
       * @param {string} string
       * @returns {module:nmodule/gx/rc/baja/Size}
       */

    }, {
      key: "decodeFromString",
      value: function decodeFromString(string) {
        if (string === 'null') {
          return Size.NULL;
        }

        var _string$split$map = string.split(',').map(baja.Double.DEFAULT.decodeFromString),
            _string$split$map2 = _slicedToArray(_string$split$map, 2),
            width = _string$split$map2[0],
            height = _string$split$map2[1];

        try {
          return new Size(width, height);
        } catch (error) {
          throw new Error("Incorrect format for Size: ".concat(error));
        }
      }
    }], [{
      key: "make",
      value: function make(width, height) {
        return new Size(width, height);
      }
    }]);

    return Size;
  }(baja.Simple);
  /**
   * @type {module:nmodule/gx/rc/baja/Size}
   */


  Size.DEFAULT = new Size(0, 0);
  /**
   * Null value for a Size.
   *
   * @type {module:nmodule/gx/rc/baja/Size}
   */

  Size.NULL = new Size(0, 0);

  function isNumber(number) {
    return typeof number === 'number';
  }

  return Size;
});
