function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _construct(Parent, args, Class) { if (_isNativeReflectConstruct()) { _construct = Reflect.construct; } else { _construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) _setPrototypeOf(instance, Class.prototype); return instance; }; } return _construct.apply(null, arguments); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
* API Status: **Private**
* @module nmodule/gx/rc/baja/PolygonGeom
*/
define(['baja!', 'underscore', 'nmodule/gx/rc/baja/Point'], function (baja, _, Point) {
  'use strict';
  /**
  * BajaScript representation of a `gx:PolygonGeom`.
  *
  * @class
  * @alias module:nmodule/gx/rc/baja/PolygonGeom
  * @extends baja.Simple
  */

  var PolygonGeom = /*#__PURE__*/function (_baja$Simple) {
    _inherits(PolygonGeom, _baja$Simple);

    var _super = _createSuper(PolygonGeom);

    /**
     * 
     * @constructor
     * @param {Array} xValues Number array of x coordinate values
     * @param {*} yValues Number array of y coordinate values
     * @param {*} size Number of points making the Polygon 
     */
    function PolygonGeom(xValues, yValues, size) {
      var _this;

      _classCallCheck(this, PolygonGeom);

      _this = _super.call(this);
      _this.$size = size;
      _this.$points = _.zip(xValues, yValues).map(function (val) {
        try {
          return new Point(val[0], val[1]);
        } catch (err) {
          throw new Error("Point: " + err.message);
        }
      });
      return _this;
    }
    /**
     * Makes a PolygonGeom from a string input of the form 
     * "x1,y1 x2,y2 x3,y3"
     * 
     * @param {*} geomString 
     * @returns {module:nmodule/gx/rc/baja/PolygonGeom}
     */


    _createClass(PolygonGeom, [{
      key: "make",
      value: function make(geomString) {
        return PolygonGeom.make(geomString);
      }
      /**
       * 
       * @returns {Number} Number of points making the Polygon
       */

    }, {
      key: "size",
      value: function size() {
        return this.$size;
      }
      /**
       * Gets the array of x coordinate values
       * 
       * @returns {Array.<Number>}
       */

    }, {
      key: "x",
      value: function x() {
        return this.$points.map(function (p) {
          return p.x();
        });
      }
      /**
       * Gets the array of y coordinate values
       * 
       * @returns {Number}
       */

    }, {
      key: "y",
      value: function y() {
        return this.$points.map(function (p) {
          return p.y();
        });
      }
      /**
       * Gets the x coordinate value at a particular index
       * 
       * @param {Number} index 
       * @returns {Number} the value at the given index
       */

    }, {
      key: "xAt",
      value: function xAt(index) {
        return this.x()[index];
      }
      /**
       * Gets the y coordinate value at a particular index
       * 
       * @param {Number} index 
       * @returns {Number} the value at the given index
       */

    }, {
      key: "yAt",
      value: function yAt(index) {
        return this.y()[index];
      }
      /**
       * 
       * @param {String} geomString 
       * @returns {module:nmodule/gx/rc/baja/PolygonGeom}
       */

    }, {
      key: "decodeFromString",
      value: function decodeFromString(geomString) {
        return PolygonGeom.make(geomString);
      }
      /**
       * Returns the string encoding of the Polygon
       * in the form 'x1,y1 x2,y2 x3,y3 x4,y4' and so on
       * 
       * @returns {String} 
       */

    }, {
      key: "encodeToString",
      value: function encodeToString() {
        if (this.isNull()) {
          return 'null';
        }

        return this.$points.map(function (p) {
          return p.encodeToString();
        }).join(' ');
      }
      /**
       * @returns {boolean}
       */

    }, {
      key: "isNull",
      value: function isNull() {
        return this === PolygonGeom.NULL;
      }
    }], [{
      key: "make",
      value: function make(geomString) {
        if (!geomString) {
          return PolygonGeom.DEFAULT;
        } else {
          geomString = geomString.trim();
        }

        if (geomString === "null") {
          return PolygonGeom.NULL;
        }

        try {
          var points = geomString.split(' ').map(Point.DEFAULT.decodeFromString),
              noOfPoints = points.length,
              arrayOfPoints = _.unzip(points.map(function (p) {
            return [p.x(), p.y()];
          }));

          return _construct(PolygonGeom, _toConsumableArray(arrayOfPoints).concat([noOfPoints]));
        } catch (error) {
          throw new Error("Incorrect format for PolygonGeom: ".concat(error.message));
        }
      }
    }]);

    return PolygonGeom;
  }(baja.Simple);

  PolygonGeom.DEFAULT = new PolygonGeom([0], [0], 0);
  PolygonGeom.NULL = new PolygonGeom([0], [0], 0);
  return PolygonGeom;
});
