function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/* eslint-env browser */

/**
* API Status: **Private**
* @module nmodule/gx/rc/baja/PathGeom
*/
define(['baja!', 'nmodule/gx/rc/baja/Point'], function (baja, Point) {
  'use strict';
  /**
  * BajaScript representation of a `gx:PathGeom`.
  *
  * @class
  * @alias module:nmodule/gx/rc/baja/PathGeom
  * @extends baja.Simple
  */

  var PathGeom = /*#__PURE__*/function (_baja$Simple) {
    _inherits(PathGeom, _baja$Simple);

    var _super = _createSuper(PathGeom);

    /**
     * 
     * @constructor
     */
    function PathGeom() {
      var _this;

      _classCallCheck(this, PathGeom);

      _this = _super.call(this);
      _this.$segments = [];
      return _this;
    }
    /**
     * Makes a PathGeom from a string input
     * 
     * @param {String} pathString 
     * @returns {module:nmodule/gx/rc/baja/PathGeom}
     */


    _createClass(PathGeom, [{
      key: "make",

      /**
       * Makes a PathGeom from a string input
       * 
       * @param {String} pathString 
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */
      value: function make(pathString) {
        return PathGeom.make(pathString);
      }
      /**
       * Adds a MoveTo segment to the path
       * 
       * @see {@link https://www.w3.org/TR/SVG/paths.html#PathDataMovetoCommands}
       * @param {boolean} isAbsolute 
       * @param {Number} x 
       * @param {Number} y
       * @returns {module:nmodule/gx/rc/baja/PathGeom} this instance
       */

    }, {
      key: "moveTo",
      value: function moveTo(isAbsolute, x, y) {
        this.add(new PathGeom.MoveTo(isAbsolute, x, y));
        return this;
      }
      /**
       * Adds a LineTo segment to the path
       * 
       * @see {@link https://www.w3.org/TR/SVG/paths.html#PathDataLinetoCommands}
       * @param {boolean} isAbsolute 
       * @param {Number} x 
       * @param {Number} y
       * @returns {module:nmodule/gx/rc/baja/PathGeom} this instance
       */

    }, {
      key: "lineTo",
      value: function lineTo(isAbsolute, x, y) {
        this.add(new PathGeom.LineTo(isAbsolute, x, y));
        return this;
      }
      /**
       * Adds a HLineTo segment to the path
       * 
       * @see {@link https://www.w3.org/TR/SVG/paths.html#PathDataLinetoCommands}
       * @param {boolean} isAbsolute 
       * @param {Number} x 
       * @returns {module:nmodule/gx/rc/baja/PathGeom} this instance
       */

    }, {
      key: "hLineTo",
      value: function hLineTo(isAbsolute, x) {
        this.add(new PathGeom.HLineTo(isAbsolute, x));
        return this;
      }
      /**
       * Adds a VLineTo segment to the path
       * 
       * @see {@link https://www.w3.org/TR/SVG/paths.html#PathDataLinetoCommands}
       * @param {boolean} isAbsolute 
       * @param {Number} y
       * @returns {module:nmodule/gx/rc/baja/PathGeom} this instance
       */

    }, {
      key: "vLineTo",
      value: function vLineTo(isAbsolute, y) {
        this.add(new PathGeom.VLineTo(isAbsolute, y));
        return this;
      }
      /**
       * Adds a cubic Bézier CurveTo segment to the path
       * 
       * @see {@link https://www.w3.org/TR/SVG/paths.html#PathDataCubicBezierCommands}
       * @param {boolean} isAbsolute 
       * @param {Number} x1
       * @param {Number} y1
       * @param {Number} x2 
       * @param {Number} y2
       * @param {Number} x
       * @param {Number} y
       * @returns {module:nmodule/gx/rc/baja/PathGeom} this instance
       */

    }, {
      key: "curveTo",
      value: function curveTo(isAbsolute, x1, y1, x2, y2, x, y) {
        this.add(new PathGeom.CurveTo(isAbsolute, x1, y1, x2, y2, x, y));
        return this;
      }
      /**
       * Adds a smooth cubic Bézier CurveTo segment to the path
       * 
       * @see {@link https://www.w3.org/TR/SVG/paths.html#PathDataCubicBezierCommands}
       * @param {boolean} isAbsolute 
       * @param {Number} x2 
       * @param {Number} y2 
       * @param {Number} x 
       * @param {Number} y
       * @returns {module:nmodule/gx/rc/baja/PathGeom} this instance
       */

    }, {
      key: "smoothCurveTo",
      value: function smoothCurveTo(isAbsolute, x2, y2, x, y) {
        this.add(new PathGeom.SmoothCurveTo(isAbsolute, x2, y2, x, y));
        return this;
      }
      /**
       * Adds a quadratic Bézier QuadTo segment to the path
       * 
       * @see {@link https://www.w3.org/TR/SVG/paths.html#PathDataQuadraticBezierCommands}
       * @param {boolean} isAbsolute 
       * @param {Number} x1 
       * @param {Number} y1 
       * @param {Number} x 
       * @param {Number} y
       * @returns {module:nmodule/gx/rc/baja/PathGeom} this instance
       */

    }, {
      key: "quadTo",
      value: function quadTo(isAbsolute, x1, y1, x, y) {
        this.add(new PathGeom.QuadTo(isAbsolute, x1, y1, x, y));
        return this;
      }
      /**
       * Adds a smooth quadratic Bézier QuadTo segment to the path
       * 
       * @see {@link https://www.w3.org/TR/SVG/paths.html#PathDataQuadraticBezierCommands}
       * @param {boolean} isAbsolute 
       * @param {Number} x
       * @param {Number} y
       * @returns {module:nmodule/gx/rc/baja/PathGeom} this instance 
       */

    }, {
      key: "smoothQuadTo",
      value: function smoothQuadTo(isAbsolute, x, y) {
        this.add(new PathGeom.SmoothQuadTo(isAbsolute, x, y));
        return this;
      }
      /**
       * Adds an ArcTo segment to the path
       * 
       * @see {@link https://www.w3.org/TR/SVG/paths.html#PathDataEllipticalArcCommands}
       * @param {boolean} isAbsolute 
       * @param {Number} rx 
       * @param {Number} ry 
       * @param {Number} xAxisRotation
       * @param {boolean} largeArcFlag
       * @param {boolean} sweepFlag
       * @param {Number} x
       * @param {Number} y
       * @returns {module:nmodule/gx/rc/baja/PathGeom} this instance  
       */

    }, {
      key: "arcTo",
      value: function arcTo(isAbsolute, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y) {
        this.add(new PathGeom.ArcTo(isAbsolute, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y));
        return this;
      }
      /**
       * Adds a ClosePath segment to the path
       * 
       * @see {@link https://www.w3.org/TR/SVG/paths.html#PathDataClosePathCommand}
       * @returns {module:nmodule/gx/rc/baja/PathGeom} this instance 
       */

    }, {
      key: "close",
      value: function close() {
        this.add(new PathGeom.ClosePath(false));
        return this;
      }
      /**
       * Pushes a new segment to the end of this path
       * 
       * @param {Segment} segment 
       */

    }, {
      key: "add",
      value: function add(segment) {
        this.$segments.push(segment);
      }
      /**
       * 
       * @returns {String}
       */

    }, {
      key: "encodeToString",
      value: function encodeToString() {
        if (this.isNull()) {
          return 'null';
        }

        var lastCmd;
        return this.$segments.map(function (s) {
          if (lastCmd === s.getCommand()) {
            return s.toString();
          } else {
            lastCmd = s.getCommand();
            return s.getCommand() + s.toString();
          }
        }).join(' ');
      }
      /**
       * Decodes a string into PathGeom
       * 
       * @param {String} pathString 
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */

    }, {
      key: "decodeFromString",
      value: function decodeFromString(pathString) {
        return PathGeom.make(pathString);
      }
      /**
       * @returns {boolean}
       */

    }, {
      key: "isNull",
      value: function isNull() {
        return this.$segments.length === 0;
      }
      /**
       * 
       * @private
       * @returns {Array<Segment>}
       */

    }, {
      key: "$getSegments",
      value: function $getSegments() {
        return this.$segments;
      }
      /**
       * 
       * @private
       * @param {String} cName 
       * @returns {Array<Segment>}
       */

    }, {
      key: "$getSegmentsByCommand",
      value: function $getSegmentsByCommand(cName) {
        return this.$segments.filter(function (s) {
          return s.getCommand().toUpperCase() === cName.toUpperCase();
        });
      }
      /**
       * 
       * @private
       * @param {Number} index
       * @returns {Segment}
       */

    }, {
      key: "$getSegmentByIndex",
      value: function $getSegmentByIndex(index) {
        return this.$segments[index];
      }
    }], [{
      key: "make",
      value: function make(pathString) {
        if (pathString === 'null') {
          return PathGeom.NULL;
        }

        return parsePath(pathString);
      }
    }]);

    return PathGeom;
  }(baja.Simple);
  /**
   * Inner implementation of path segments.
   * 
   * @memberOf module:nmodule/gx/rc/baja/PathGeom
   */


  var Segment = /*#__PURE__*/function () {
    /**
     * 
     * @constructor
     * @param {boolean} isAbsolute True if the segment has absolute coordinates 
     */
    function Segment(isAbsolute) {
      _classCallCheck(this, Segment);

      this.$isAbsolute = isAbsolute;
    }
    /**
     * True if the segment has absolute coordinates
     * @returns {boolean}
     */


    _createClass(Segment, [{
      key: "getAbsolute",
      value: function getAbsolute() {
        return this.$isAbsolute;
      }
      /**
       * True if the segment does not have absolute coordinates
       * @returns {boolean}
       */

    }, {
      key: "getRelative",
      value: function getRelative() {
        return !this.$isAbsolute;
      }
      /**
       * 
       * @returns {String} string representation of the Path command
       */

    }, {
      key: "getCommand",
      value: function getCommand() {
        throw new Error('not implemented');
      }
      /**
       * 
       * @returns {String}
       */

    }, {
      key: "toString",
      value: function toString() {}
    }]);

    return Segment;
  }();
  /**
   * 
   * @extends Segment
   */


  var ClosePath = /*#__PURE__*/function (_Segment) {
    _inherits(ClosePath, _Segment);

    var _super2 = _createSuper(ClosePath);

    function ClosePath() {
      _classCallCheck(this, ClosePath);

      return _super2.apply(this, arguments);
    }

    _createClass(ClosePath, [{
      key: "getCommand",
      value: function getCommand() {
        return 'Z'; // Case does not matter
      }
    }, {
      key: "toString",
      value: function toString() {
        return '';
      }
    }]);

    return ClosePath;
  }(Segment);

  var MoveTo = /*#__PURE__*/function (_Segment2) {
    _inherits(MoveTo, _Segment2);

    var _super3 = _createSuper(MoveTo);

    function MoveTo(isAbsolute, x, y) {
      var _this2;

      _classCallCheck(this, MoveTo);

      _this2 = _super3.call(this, isAbsolute);

      try {
        _this2.$point = new Point(x, y);
      } catch (err) {
        throw new Error("MoveTo Point: " + err.message);
      }

      return _this2;
    }

    _createClass(MoveTo, [{
      key: "getCommand",
      value: function getCommand() {
        return this.getAbsolute() ? 'M' : 'm';
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.$point.encodeToString();
      }
    }, {
      key: "getPoint",
      value: function getPoint() {
        return this.$point;
      }
    }]);

    return MoveTo;
  }(Segment);

  var LineTo = /*#__PURE__*/function (_Segment3) {
    _inherits(LineTo, _Segment3);

    var _super4 = _createSuper(LineTo);

    function LineTo(isAbsolute, x, y) {
      var _this3;

      _classCallCheck(this, LineTo);

      _this3 = _super4.call(this, isAbsolute);

      try {
        _this3.$point = new Point(x, y);
      } catch (err) {
        throw new Error("LineTo Point: " + err.message);
      }

      return _this3;
    }

    _createClass(LineTo, [{
      key: "getCommand",
      value: function getCommand() {
        return this.getAbsolute() ? 'L' : 'l';
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.$point.encodeToString();
      }
    }, {
      key: "getPoint",
      value: function getPoint() {
        return this.$point;
      }
    }]);

    return LineTo;
  }(Segment);

  var HLineTo = /*#__PURE__*/function (_Segment4) {
    _inherits(HLineTo, _Segment4);

    var _super5 = _createSuper(HLineTo);

    function HLineTo(isAbsolute, x) {
      var _this4;

      _classCallCheck(this, HLineTo);

      _this4 = _super5.call(this, isAbsolute);

      if (!isNumber(x)) {
        throw new Error('HLineTo: x coordinate is not a valid number.');
      }

      _this4.$x = x;
      return _this4;
    }

    _createClass(HLineTo, [{
      key: "getCommand",
      value: function getCommand() {
        return this.getAbsolute() ? 'H' : 'h';
      }
    }, {
      key: "getX",
      value: function getX() {
        return this.$x;
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.$x.encodeToString();
      }
    }]);

    return HLineTo;
  }(Segment);

  var VLineTo = /*#__PURE__*/function (_Segment5) {
    _inherits(VLineTo, _Segment5);

    var _super6 = _createSuper(VLineTo);

    function VLineTo(isAbsolute, y) {
      var _this5;

      _classCallCheck(this, VLineTo);

      _this5 = _super6.call(this, isAbsolute);

      if (!isNumber(y)) {
        throw new Error('VLineTo: y coordinate is not a valid number.');
      }

      _this5.$y = y;
      return _this5;
    }

    _createClass(VLineTo, [{
      key: "getCommand",
      value: function getCommand() {
        return this.getAbsolute() ? 'V' : 'v';
      }
    }, {
      key: "getY",
      value: function getY() {
        return this.$y;
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.$y.encodeToString();
      }
    }]);

    return VLineTo;
  }(Segment);

  var CurveTo = /*#__PURE__*/function (_Segment6) {
    _inherits(CurveTo, _Segment6);

    var _super7 = _createSuper(CurveTo);

    function CurveTo(isAbsolute, x1, y1, x2, y2, x, y) {
      var _this6;

      _classCallCheck(this, CurveTo);

      _this6 = _super7.call(this, isAbsolute);

      try {
        _this6.$cp1 = new Point(x1, y1);
      } catch (err) {
        throw new Error("CurveTo Control Point: " + err.message);
      }

      try {
        _this6.$cp2 = new Point(x2, y2);
      } catch (err) {
        throw new Error("CurveTo Control Point: " + err.message);
      }

      try {
        _this6.$end = new Point(x, y);
      } catch (err) {
        throw new Error("CurveTo Point: " + err.message);
      }

      return _this6;
    }

    _createClass(CurveTo, [{
      key: "getCommand",
      value: function getCommand() {
        return this.getAbsolute() ? 'C' : 'c';
      }
    }, {
      key: "getCp1",
      value: function getCp1() {
        return this.$cp1;
      }
    }, {
      key: "getCp2",
      value: function getCp2() {
        return this.$cp2;
      }
    }, {
      key: "getEnd",
      value: function getEnd() {
        return this.$end;
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.$cp1.encodeToString() + ' ' + this.$cp2.encodeToString() + ' ' + this.$end.encodeToString();
      }
    }]);

    return CurveTo;
  }(Segment);

  var SmoothCurveTo = /*#__PURE__*/function (_Segment7) {
    _inherits(SmoothCurveTo, _Segment7);

    var _super8 = _createSuper(SmoothCurveTo);

    function SmoothCurveTo(isAbsolute, x2, y2, x, y) {
      var _this7;

      _classCallCheck(this, SmoothCurveTo);

      _this7 = _super8.call(this, isAbsolute);

      try {
        _this7.$cp2 = new Point(x2, y2);
      } catch (err) {
        throw new Error("SmoothCurveTo Control Point: " + err.message);
      }

      try {
        _this7.$end = new Point(x, y);
      } catch (err) {
        throw new Error("SmoothCurveTo Point: " + err.message);
      }

      return _this7;
    }

    _createClass(SmoothCurveTo, [{
      key: "getCommand",
      value: function getCommand() {
        return this.getAbsolute() ? 'S' : 's';
      }
    }, {
      key: "getCp2",
      value: function getCp2() {
        return this.$cp2;
      }
    }, {
      key: "getEnd",
      value: function getEnd() {
        return this.$end;
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.$cp2.encodeToString() + ' ' + this.$end.encodeToString();
      }
    }]);

    return SmoothCurveTo;
  }(Segment);

  var QuadTo = /*#__PURE__*/function (_Segment8) {
    _inherits(QuadTo, _Segment8);

    var _super9 = _createSuper(QuadTo);

    function QuadTo(isAbsolute, x1, y1, x, y) {
      var _this8;

      _classCallCheck(this, QuadTo);

      _this8 = _super9.call(this, isAbsolute);

      try {
        _this8.$cp = new Point(x1, y1);
      } catch (err) {
        throw new Error("QuadTo Control Point: " + err.message);
      }

      try {
        _this8.$end = new Point(x, y);
      } catch (err) {
        throw new Error("QuadTo Point: " + err.message);
      }

      return _this8;
    }

    _createClass(QuadTo, [{
      key: "getCommand",
      value: function getCommand() {
        return this.getAbsolute() ? 'Q' : 'q';
      }
    }, {
      key: "getCp",
      value: function getCp() {
        return this.$cp;
      }
    }, {
      key: "getEnd",
      value: function getEnd() {
        return this.$end;
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.$cp.encodeToString() + ' ' + this.$end.encodeToString();
      }
    }]);

    return QuadTo;
  }(Segment);

  var SmoothQuadTo = /*#__PURE__*/function (_Segment9) {
    _inherits(SmoothQuadTo, _Segment9);

    var _super10 = _createSuper(SmoothQuadTo);

    function SmoothQuadTo(isAbsolute, x, y) {
      var _this9;

      _classCallCheck(this, SmoothQuadTo);

      _this9 = _super10.call(this, isAbsolute);

      try {
        _this9.$end = new Point(x, y);
      } catch (err) {
        throw new Error("SmoothQuadTo Point: " + err.message);
      }

      return _this9;
    }

    _createClass(SmoothQuadTo, [{
      key: "getCommand",
      value: function getCommand() {
        return this.getAbsolute() ? 'T' : 't';
      }
    }, {
      key: "getEnd",
      value: function getEnd() {
        return this.$end;
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.$end.encodeToString();
      }
    }]);

    return SmoothQuadTo;
  }(Segment);

  var ArcTo = /*#__PURE__*/function (_Segment10) {
    _inherits(ArcTo, _Segment10);

    var _super11 = _createSuper(ArcTo);

    function ArcTo(isAbsolute, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y) {
      var _this10;

      _classCallCheck(this, ArcTo);

      _this10 = _super11.call(this, isAbsolute);

      if (!isNumber(rx)) {
        throw new Error('ArcTo: radius x not a valid number.');
      }

      if (!isNumber(ry)) {
        throw new Error('ArcTo: radius y not a valid number.');
      }

      if (!isNumber(xAxisRotation)) {
        throw new Error('ArcTo: x axis rotaion not a valid number.');
      }

      try {
        _this10.$end = new Point(x, y);
      } catch (err) {
        throw new Error("ArcTo Point: " + err.message);
      }

      _this10.$largeArcFlag = Boolean.make(!!largeArcFlag);
      _this10.$sweepFlag = Boolean.make(!!sweepFlag);
      _this10.$rx = rx;
      _this10.$ry = ry;
      _this10.$xAxisRotation = xAxisRotation;
      return _this10;
    }

    _createClass(ArcTo, [{
      key: "getCommand",
      value: function getCommand() {
        return this.getAbsolute() ? 'A' : 'a';
      }
    }, {
      key: "getRadiusX",
      value: function getRadiusX() {
        return this.$rx;
      }
    }, {
      key: "getRadiusY",
      value: function getRadiusY() {
        return this.$ry;
      }
    }, {
      key: "getXAxisRotation",
      value: function getXAxisRotation() {
        return this.$xAxisRotation;
      }
    }, {
      key: "getLargeArcFlag",
      value: function getLargeArcFlag() {
        return this.$largeArcFlag;
      }
    }, {
      key: "getSweepFlag",
      value: function getSweepFlag() {
        return this.$sweepFlag;
      }
    }, {
      key: "getEnd",
      value: function getEnd() {
        return this.$end;
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.$rx.encodeToString() + ',' + this.$ry.encodeToString() + ' ' + this.$xAxisRotation.encodeToString() + ' ' + this.$largeArcFlag.getOrdinal().encodeToString() + ',' + this.$sweepFlag.getOrdinal().encodeToString() + ' ' + this.$end.encodeToString();
      }
    }]);

    return ArcTo;
  }(Segment);

  PathGeom.DEFAULT = new PathGeom();
  PathGeom.NULL = PathGeom.DEFAULT;
  /**
   * Parse the path string and return a list of Segments
   * 
   * @param {String} pathString 
   * @return {Array<Segment>}
   */

  function parsePath(pathString) {
    var cmdRegEx = /([MLHVCSQTAZ])([^MLHVCSQTAZ]*)/gi,
        commands = pathString.match(cmdRegEx);
    var pathGeom = new PathGeom();
    commands.map(function (c) {
      var cmdArg = c.substring(1).trim();

      switch (c[0].toUpperCase()) {
        case 'M':
          {
            var points = parsePoints(cmdArg);
            return points.forEach(function (p) {
              return pathGeom.moveTo(isAbsolute(c[0]), p.x, p.y);
            });
          }

        case 'L':
          {
            var _points = parsePoints(cmdArg);

            return _points.map(function (p) {
              return pathGeom.lineTo(isAbsolute(c[0]), p.x, p.y);
            });
          }

        case 'H':
          {
            var xs = parseArgs(cmdArg);

            if (!xs) {
              throw new Error('Invalid HLineTo segment.');
            }

            return xs.map(function (x) {
              return pathGeom.hLineTo(isAbsolute(c[0]), x);
            });
          }

        case 'V':
          {
            var ys = parseArgs(cmdArg);

            if (!ys) {
              throw new Error('Invalid VLineTo segment.');
            }

            return ys.map(function (y) {
              return pathGeom.vLineTo(isAbsolute(c[0]), y);
            });
          }

        case 'C':
          {
            var cGroup = getArgChunks(parsePoints(cmdArg), 3, []);
            return cGroup.map(function (points) {
              return pathGeom.curveTo(isAbsolute(c[0]), points[0].x, points[0].y, points[1].x, points[1].y, points[2].x, points[2].y);
            });
          }

        case 'S':
          {
            var _cGroup = getArgChunks(parsePoints(cmdArg), 2, []);

            return _cGroup.map(function (points) {
              return pathGeom.smoothCurveTo(isAbsolute(c[0]), points[0].x, points[0].y, points[1].x, points[1].y);
            });
          }

        case 'Q':
          {
            var _cGroup2 = getArgChunks(parsePoints(cmdArg), 2, []);

            return _cGroup2.map(function (points) {
              return pathGeom.quadTo(isAbsolute(c[0]), points[0].x, points[0].y, points[1].x, points[1].y);
            });
          }

        case 'T':
          {
            var _cGroup3 = getArgChunks(parsePoints(cmdArg), 1, []);

            return _cGroup3.map(function (points) {
              return pathGeom.smoothQuadTo(isAbsolute(c[0]), points[0].x, points[0].y);
            });
          }

        case 'A':
          {
            var args = parseArgs(cmdArg);

            if (!args) {
              throw new Error('Invalid ArcTo segment.');
            }

            var arcs = getArgChunks(args, 7, []);
            return arcs.map(function (arcArgs) {
              if (arcArgs.length !== 7) {
                throw new Error('Incorrect Arc syntax.');
              }

              return pathGeom.arcTo.apply(pathGeom, [isAbsolute(c[0])].concat(_toConsumableArray(arcArgs)));
            });
          }

        case 'Z':
          {
            return pathGeom.close(false);
          }

        default:
          {
            throw new Error("Unknown Command");
          }
      }
    });
    return pathGeom;
  }
  /**
   * Parse each command arguments and return as list of points
   * 
   * @param {String} str 
   * @returns {Array<Object>} of the form {x:xVal, y:yVal}
   */


  function parsePoints(str) {
    var values = parseArgs(str);

    if (!values) {
      throw new Error('Invalid geom');
    }

    return values.reduce(function (points, val, i, vals) {
      if (i % 2 === 0) {
        points.push({
          x: parseFloat(val, 10),
          y: parseFloat(vals[i + 1], 10)
        });
      }

      return points;
    }, []);
  }
  /**
   * 
   * @param {String} str 
   * @returns {Array<Number>|null}
   */


  function parseArgs(str) {
    var valRegEx = /-?\d*\.?\d+/g;
    var argValues = str.match(valRegEx);
    return argValues && argValues.map(function (v) {
      return parseFloat(v, 10);
    });
  }

  function isAbsolute(_char) {
    return _char === _char.toUpperCase();
  }
  /**
   * Return groups of segment argument values sized by n
   * 
   * @param {Array<Object>} args 
   * @param {Number} n size of the group/chunk
   * @returns {Array<Array<Object>>} of size n chunks
   */


  function getArgChunks(args, n, g) {
    return args.length === 0 ? g : getArgChunks(args.slice(n), n, g.concat([args.slice(0, n)]));
  }

  function isNumber(number) {
    return typeof number === 'number';
  }

  PathGeom.MoveTo = MoveTo;
  PathGeom.LineTo = LineTo;
  PathGeom.HLineTo = HLineTo;
  PathGeom.VLineTo = VLineTo;
  PathGeom.CurveTo = CurveTo;
  PathGeom.SmoothCurveTo = SmoothCurveTo;
  PathGeom.QuadTo = QuadTo;
  PathGeom.SmoothQuadTo = SmoothQuadTo;
  PathGeom.ArcTo = ArcTo;
  PathGeom.ClosePath = ClosePath;
  return PathGeom;
});
