function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
* API Status: **Private**
* @module nmodule/gx/rc/baja/LineGeom
*/
define(['baja!', 'nmodule/gx/rc/baja/Point'], function (baja, Point) {
  'use strict';
  /**
  * BajaScript representation of a `gx:LineGeom`.
  *
  * @class
  * @alias module:nmodule/gx/rc/baja/LineGeom
  * @extends baja.Simple
  */

  var LineGeom = /*#__PURE__*/function (_baja$Simple) {
    _inherits(LineGeom, _baja$Simple);

    var _super = _createSuper(LineGeom);

    function LineGeom(x1, y1, x2, y2) {
      var _this;

      _classCallCheck(this, LineGeom);

      _this = _super.call(this);

      try {
        _this.$point1 = new Point(x1, y1);
      } catch (err) {
        throw new Error("Point1: " + err.message);
      }

      try {
        _this.$point2 = new Point(x2, y2);
      } catch (err) {
        throw new Error("Point2: " + err.message);
      }

      return _this;
    }
    /**
     * Gets the x coordinate of the first/start point
     * @returns {Number}
     */


    _createClass(LineGeom, [{
      key: "x1",
      value: function x1() {
        return this.$point1.x();
      }
      /**
       * Gets the y coordinate of the first/start point
       * @returns {Number}
       */

    }, {
      key: "y1",
      value: function y1() {
        return this.$point1.y();
      }
      /**
       * Gets the x coordinate of the second/end point
       * @returns {Number}
       */

    }, {
      key: "x2",
      value: function x2() {
        return this.$point2.x();
      }
      /**
       * Gets the y coordinate of the second/end point
       * @returns {Number}
       */

    }, {
      key: "y2",
      value: function y2() {
        return this.$point2.y();
      }
      /**
       * Makes a LineGeom from a string input of the form 
       * "x1,y1 x2,y2"
       * 
       * @param {String} geomString 
       * @returns {module:nmodule/gx/rc/baja/LineGeom}
       */

    }, {
      key: "make",
      value: function make(geomString) {
        return LineGeom.make(geomString);
      }
      /**
       * Convenience to make a line from two gx:Point instances
       * 
       * @param {module:nmodule/gx/rc/baja/Point} start 
       * @param {module:nmodule/gx/rc/baja/Point} end 
       * @returns {module:nmodule/gx/rc/baja/LineGeom}
       */

    }, {
      key: "fromPoint",
      value: function fromPoint(start, end) {
        return LineGeom.fromPoints(start, end);
      }
      /**
       * Encoded as x1,y1 x2,y2
       * 
       * @returns {String}
       */

    }, {
      key: "encodeToString",
      value: function encodeToString() {
        if (this.isNull()) {
          return 'null';
        }

        return [this.$point1, this.$point2].map(function (p) {
          return p.encodeToString();
        }).join(' ');
      }
      /**
       * 
       * @param {String} geomString 
       * @returns {module:nmodule/gx/rc/baja/LineGeom}
       */

    }, {
      key: "decodeFromString",
      value: function decodeFromString(geomString) {
        return LineGeom.make(geomString);
      }
      /**
       * @returns {boolean}
       */

    }, {
      key: "isNull",
      value: function isNull() {
        return this === LineGeom.NULL;
      }
    }], [{
      key: "make",
      value: function make(geomString) {
        if (geomString === "null") {
          return LineGeom.NULL;
        }

        var _geomString$split$map = geomString.split(' ').map(Point.DEFAULT.decodeFromString),
            _geomString$split$map2 = _slicedToArray(_geomString$split$map, 2),
            p1 = _geomString$split$map2[0],
            p2 = _geomString$split$map2[1];

        try {
          return new LineGeom(p1.x(), p1.y(), p2.x(), p2.y());
        } catch (error) {
          throw new Error("Incorrect format for LineGeom: ".concat(error.message));
        }
      }
    }, {
      key: "fromPoints",
      value: function fromPoints(start, end) {
        return new LineGeom(start.x(), start.y(), end.x(), end.y());
      }
    }]);

    return LineGeom;
  }(baja.Simple);

  LineGeom.DEFAULT = new LineGeom(0, 0, 0, 0);
  LineGeom.NULL = new LineGeom(0, 0, 0, 0);
  return LineGeom;
});
