function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/**
 * API Status: **Private**
 * @module nmodule/gx/rc/baja/Insets
 */
define(['baja!', 'lex!gx'], function (baja, lexs) {
  "use strict";

  var _lexs = _slicedToArray(lexs, 1),
      gxLex = _lexs[0];
  /**
   * A javascript based implementation of gx:Insets
   *
   * @class
   * @alias module:nmodule/gx/rc/baja/Insets
   * @extends baja.Simple
   */


  var Insets = /*#__PURE__*/function (_baja$Simple) {
    _inherits(Insets, _baja$Simple);

    var _super = _createSuper(Insets);

    /**
     * Constructs Insets with the given top, right, bottom and left. Will throw an error if top, right, bottom and left is not a numeric type.
     * Not a number and positive infinite values are accepted.
     *
     * @param {number} top
     * @param {number} right
     * @param {number} bottom
     * @param {number} left
     */
    function Insets(top, right, bottom, left) {
      var _this;

      _classCallCheck(this, Insets);

      _this = _super.call(this);

      if (!isNumber(top)) {
        throw new Error(gxLex.get('insets.error', gxLex.get('insets.top'), top));
      }

      if (!isNumber(right)) {
        throw new Error(gxLex.get('insets.error', gxLex.get('insets.right'), right));
      }

      if (!isNumber(bottom)) {
        throw new Error(gxLex.get('insets.error', gxLex.get('insets.bottom'), bottom));
      }

      if (!isNumber(left)) {
        throw new Error(gxLex.get('insets.error', gxLex.get('insets.left'), left));
      }

      _this.$top = top;
      _this.$right = right;
      _this.$bottom = bottom;
      _this.$left = left;
      return _this;
    }
    /**
     * Constructs an Insets with the given top, right, bottom and left; this is an instance method.
     *
     * @example
     * // creates an inset with specified top, right, bottom and left values
     * let insets = Insets.make(100,200,300,400);
     *
     * @example
     * // creates an inset with specified top. In this case the right, bottom and left inset will be defaulted to the top inset value
     * let insets = Insets.make(100);
     *
     * @param   {...number} side
     * @returns {module:nmodule/gx/rc/baja/Insets}
     */


    _createClass(Insets, [{
      key: "make",
      value: function make() {
        return Insets.make.apply(Insets, arguments);
      }
      /**
       * Makes an Insets with top, right, bottom and left values
       *
       * @param {number} top
       * @param {number} right
       * @param {number} bottom
       * @param {number} left
       * @returns {module:nmodule/gx/rc/baja/Insets}
       */

    }, {
      key: "getTop",

      /**
       * Get the top value of the Inset
       *
       * @returns {number}
       */
      value: function getTop() {
        return this.$top;
      }
      /**
       * Get the right value of the Inset
       *
       * @returns {number}
       */

    }, {
      key: "getRight",
      value: function getRight() {
        return this.$right;
      }
      /**
       * Get the bottom value of the Inset
       *
       * @returns {number}
       */

    }, {
      key: "getBottom",
      value: function getBottom() {
        return this.$bottom;
      }
      /**
       * Get the left value of the Inset
       *
       * @returns {number}
       */

    }, {
      key: "getLeft",
      value: function getLeft() {
        return this.$left;
      }
      /**
       * Encodes the Insets to  "Top Right Bottom Left" format.
       *
       * @returns {string}
       */

    }, {
      key: "encodeToString",
      value: function encodeToString() {
        function checkNaN(side1, side2) {
          return isNaN(side1) && isNaN(side2);
        }

        if (this === Insets.NULL) {
          return 'null';
        }

        var numberEqual = this.$top === this.$bottom && this.$left === this.$right,
            nanEqual = checkNaN(this.$top, this.$bottom) && checkNaN(this.$left, this.$right);

        if (numberEqual || nanEqual) {
          if (this.$top === this.$right || checkNaN(this.$top, this.$right)) {
            return this.$top.encodeToString();
          } else {
            return this.$top.encodeToString() + ' ' + this.$right.encodeToString();
          }
        } else {
          var stringTop = this.$top.encodeToString();
          var stringRight = ' ' + this.$right.encodeToString();
          var stringBottom = ' ' + this.$bottom.encodeToString();
          var stringLeft = ' ' + this.$left.encodeToString();
          return "".concat(stringTop).concat(stringRight).concat(stringBottom).concat(stringLeft);
        }
      }
      /**
       * Converts a string value into an Inset tuple. Throws an error if the string is not in the valid format.
       * @param {string} string
       * @returns {module:nmodule/gx/rc/baja/Insets}
       */

    }, {
      key: "decodeFromString",
      value: function decodeFromString(string) {
        var top, right, bottom, left;

        if (string === 'null') {
          return Insets.NULL;
        }

        var sides = string.split(" ").map(baja.Double.DEFAULT.decodeFromString);
        top = sides[0];

        if (isNumber(sides[1])) {
          right = sides[1];

          if (isNumber(sides[2])) {
            bottom = sides[2];

            if (isNumber(sides[3])) {
              left = sides[3];
              return Insets.make(top, right, bottom, left);
            }

            return Insets.make(top, right, bottom, right);
          }

          return Insets.make(top, right, top, right);
        }

        return Insets.make(top);
      }
      /**
       * @returns {string} a CSS string applicable to padding or margin
       */

    }, {
      key: "toCssString",
      value: function toCssString() {
        return "".concat(this.$top, "px ").concat(this.$right, "px ").concat(this.$bottom, "px ").concat(this.$left, "px");
      }
      /**
       * Applies the insets as padding to the element style.
       * @param {HTMLElement} el
       */

    }, {
      key: "applyPaddingToElement",
      value: function applyPaddingToElement(el) {
        el.style.padding = this.toCssString();
      }
      /**
       * Applies the insets as margin to the element style.
       * @param {HTMLElement} el
       */

    }, {
      key: "applyMarginToElement",
      value: function applyMarginToElement(el) {
        el.style.margin = this.toCssString();
      }
      /**
       * An inset is visible if there is at least one non-zero side.
       * @return {boolean}
       */

    }, {
      key: "isVisible",
      value: function isVisible() {
        return !!(this.$top || this.$right || this.$bottom || this.$left);
      }
    }], [{
      key: "make",
      value: function make() {
        var top, right, bottom, left;

        for (var _len = arguments.length, side = new Array(_len), _key = 0; _key < _len; _key++) {
          side[_key] = arguments[_key];
        }

        if (side.length === 4) {
          top = side[0];
          right = side[1];
          bottom = side[2];
          left = side[3];
        } else if (side.length === 1) {
          top = right = bottom = left = side[0];
        }

        return new Insets(top, right, bottom, left);
      }
    }]);

    return Insets;
  }(baja.Simple);
  /**
   * Default value for Insets
   *
   * @type {module:nmodule/gx/rc/baja/Insets}
   */


  Insets.DEFAULT = new Insets(0, 0, 0, 0);
  /**
   * Null value for Insets.
   *
   * @type {module:nmodule/gx/rc/baja/Insets}
   */

  Insets.NULL = new Insets(0, 0, 0, 0);

  function isNumber(number) {
    return typeof number === 'number';
  }

  return Insets;
});
