function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/gx/rc/baja/Color
 */
define(['baja!', 'nmodule/gx/rc/util/colorUtils'], function (baja, colorUtils) {
  'use strict';

  var parseRgba = colorUtils.parseRgba,
      toRgbCssString = colorUtils.toRgbCssString;
  var cache = {};
  /**
   * @alias module:nmodule/gx/rc/baja/Color
   * @extends baja.Simple
   */

  var Color = /*#__PURE__*/function (_baja$Simple) {
    _inherits(Color, _baja$Simple);

    var _super = _createSuper(Color);

    /**
     * @param {number} rgba the RGBA numbers representing this color (all 0-255)
     * @param {string} [str] the string encoding if known; otherwise will be
     * generated from the rgba numbers
     */
    function Color(rgba, str) {
      var _this;

      _classCallCheck(this, Color);

      _this = _super.call(this);
      _this.$str = str;
      _this.$rgba = rgba;
      return _this;
    }
    /**
     * @param {string|object|number[]} str string encoding, or an object
     * with `r`, `g`, `b`, and/or `a` properties, or an array of values
     * @returns {module:nmodule/gx/rc/baja/Color}
     */


    _createClass(Color, [{
      key: "make",

      /**
       * @param {string} str
       * @returns {module:nmodule/gx/rc/baja/Color}
       */
      value: function make(str) {
        return Color.make(str);
      }
      /**
       ** @param str
       * @returns {module:nmodule/gx/rc/baja/Color}
       */

    }, {
      key: "decodeFromString",
      value: function decodeFromString(str) {
        return Color.make(str);
      }
      /**
       * @returns {string} the color encoded to string. `#rrggbb` format if alpha
       * is 255; `#aarrggbb` format otherwise
       */

    }, {
      key: "encodeToString",
      value: function encodeToString() {
        var str = this.$str;

        if (!str) {
          var alpha = this.getAlpha();
          str = toHex(this.getRed()) + toHex(this.getGreen()) + toHex(this.getBlue());

          if (alpha !== 255) {
            str = toHex(alpha) + str;
          }

          str = '#' + str;
          this.$str = str;
        }

        return str;
      }
      /**
       * @returns {number} red [0-255]
       */

    }, {
      key: "getRed",
      value: function getRed() {
        return this.$rgba[0];
      }
      /**
       * @returns {number} green [0-255]
       */

    }, {
      key: "getGreen",
      value: function getGreen() {
        return this.$rgba[1];
      }
      /**
       * @returns {number} blue [0-255]
       */

    }, {
      key: "getBlue",
      value: function getBlue() {
        return this.$rgba[2];
      }
      /**
       * @returns {number} alpha [0-255]
       */

    }, {
      key: "getAlpha",
      value: function getAlpha() {
        return this.$rgba[3];
      }
    }, {
      key: "getRgba",
      value: function getRgba() {
        return this.$rgba.slice();
      }
      /**
       * @returns {string} a CSS-compatible string representing this color
       */

    }, {
      key: "toCssString",
      value: function toCssString() {
        return toRgbCssString(this.$rgba);
      }
      /**
       * @returns {string} a CSS-compatible string representing this color
       */

    }, {
      key: "toString",
      value: function toString() {
        return this.toCssString();
      }
    }], [{
      key: "make",
      value: function make(str) {
        if (str === 'null' || !str) {
          return Color.NULL;
        }

        var rgba;

        if (Array.isArray(str)) {
          rgba = str.slice();

          if (rgba.length === 3) {
            rgba.push(0xff);
          }
        } else if (_typeof(str) === 'object') {
          var _str$r = str.r,
              r = _str$r === void 0 ? 0 : _str$r,
              _str$g = str.g,
              g = _str$g === void 0 ? 0 : _str$g,
              _str$b = str.b,
              b = _str$b === void 0 ? 0 : _str$b,
              _str$a = str.a,
              a = _str$a === void 0 ? 0xff : _str$a;
          rgba = [r, g, b, a];
        } else {
          rgba = parseRgba(str);
        }

        var key = rgba.join();
        return cache[key] || (cache[key] = new Color(rgba));
      }
    }]);

    return Color;
  }(baja.Simple);

  Color.DEFAULT = Color.make('black');
  Color.NULL = new Color([0, 0, 0, 0], 'null');

  function toHex(n) {
    var str = n.toString(16).toLowerCase();

    if (str.length === 1) {
      str = '0' + str;
    }

    return str;
  }

  return Color;
});
