/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webChart/rc/fe/SimplePropertySheet
 */
define(['nmodule/webEditors/rc/wb/PropertySheet'], function (PropertySheet) {
  "use strict";

  /**
   * A SimplePropertySheet is the editor for any Component.
   *
   * @class
   * @alias module:nmodule/webChart/rc/fe/SimplePropertySheet
   * @extends module:nmodule/webEditors/rc/wb/PropertySheet
   */

  var SimplePropertySheet = function SimplePropertySheet(params) {
    PropertySheet.call(this, {
      properties: {
        showHeader: false,
        showControls: false,
        nested: true
      }
    });
  };
  SimplePropertySheet.prototype = Object.create(PropertySheet.prototype);
  SimplePropertySheet.prototype.constructor = SimplePropertySheet;

  return SimplePropertySheet;
});
