/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * Created by E491819 on 7/4/2016.
 */
define(function () {

  "use strict";

  /**
   * The list of constants to be used in the reporting UI.
   *
   * @alias nmodule/analytics/rc/report/util/reportConstants
   */

  var reportConstants = function reportConstants() {};
  reportConstants.MIN_COLOR = "#0000FF";
  reportConstants.AVG_COLOR = "#FFFFFF";
  reportConstants.MAX_COLOR = "#FF0000";
  reportConstants.DEFAULT_NODE = "{}";
  reportConstants.DEFAULT_TIMERANGE = "today";
  reportConstants.DEFAULT_BASELINE = "yesterday";
  reportConstants.DEFAULT_INTERVAL = "none";
  reportConstants.DEFAULT_ROLLUP = "first";
  reportConstants.DEFAULT_AGGREGATION = "first";
  reportConstants.DEFAULT_DATATAG = "n:history";
  reportConstants.DEFAULT_UNITS = "null";
  reportConstants.ALL_DAYS_SELECTED_BITS = "0x7F";
  reportConstants.REPORT_MAX_HEIGHT = "90%";
  reportConstants.REPORT_CHART_HEIGHT = "55%";
  reportConstants.REPORT_TABLE_HEIGHT = "35%";
  reportConstants.REPORT_MAX_WIDTH = "100%";
  reportConstants.REPORT_CONFIG_WIDTH = "33%";
  reportConstants.REPORT_CONTENT_WIDTH = "65%";
  reportConstants.DEFAULT_CHART_PLOT_VALUE = "avg";
  reportConstants.TABLE_TIMESTAMP_FORMAT = "MMMM Do YYYY, HH:mm:ss";
  reportConstants.LASTUPDATE_TIMESTAMP_FORMAT = "MMMM Do YYYY, HH:mm";
  reportConstants.DEFAULT_REP_LIST_COL_COUNT = 5;
  reportConstants.DEFAULT_REP_LIST_ROW_COUNT = 2;
  reportConstants.DEFAULT_LEGEND_POSITION = "inset";
  reportConstants.ERR_CODE_PERMISSION = 1;
  reportConstants.DEFAULT_BASELINE_TEMP_VALUE = 65;
  reportConstants.DEFAULT_MISSING_DATA_CFG = {
    aggStrategy: "ignoreSeries",
    intpAlgorithm: "none",
    knnValue: 1
  };
  return reportConstants;
});
