/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/*jshint browser: true */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/menu/AnalyticReportView
 */
define(['baja!', 'baja!baja:Link', 'lex!bajaux,webEditors', 'jquery', 'Promise', 'underscore', 'bajaux/Widget', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/analytics/rc/report/util/reportConstants', 'nmodule/analytics/rc/report/container/aggregation/AggregationReport', 'nmodule/analytics/rc/report/container/avgprofile/AverageProfileReport', 'nmodule/analytics/rc/report/container/loadduration/LoadDurationReport', 'nmodule/analytics/rc/report/container/ranking/RankingReport', 'nmodule/analytics/rc/report/container/equipop/EquipmentOperationReport', 'nmodule/analytics/rc/report/container/relcontrib/RelativeContributionReport', 'nmodule/analytics/rc/report/container/spectrum/SpectrumReport', 'nmodule/analytics/rc/report/util/reportWidgetEvents', 'hbs!nmodule/analytics/rc/report/menu/reportListTemplate'], function (baja, types, lexs, $, Promise, _, Widget, asyncUtils, reportConstants, AggregationReport, AverageProfileReport, LoadDurationReport, RankingReport, EquipmentOperationReport, RelativeContributionReport, SpectrumReport, reportWidgetEvents, reportListTemplate) {

    'use strict';

    /**
     * AnalyticReportView
     * @class
     * @alias nmodule/analytics/rc/report/menu/AnalyticReportView
     * @extends module:bajaux/Widget
     * @param params
     */

    var AnalyticReportView = function AnalyticReportView(params) {
        this.params = params;
        Widget.call(this, params);
        this.$report = new SpectrumReport(params);
    };
    AnalyticReportView.prototype = Object.create(Widget.prototype);
    AnalyticReportView.prototype.constructor = AnalyticReportView;

    /**
     * render the template
     * @param dom
     */
    AnalyticReportView.prototype.doInitialize = function (dom) {
        dom.append("<div class='rc' style='width: 100%;height: 100%;'>");
        return Widget.prototype.doInitialize.apply(this, arguments);
    };

    /**
     * Loads the component. If the component is mounted and has actions to fire,
     * the "actions" command will be enabled.
     *
     * @param {baja.Complex} complex
     * @returns {Promise} promise to be resolved when the complex has
     * loaded and the actions command has been enabled or disabled.
     */
    AnalyticReportView.prototype.doLoad = function (report) {
        var that = this;
        return report.lease().then(function () {
            var rType = report.getReportType().getTag();
            var params = that.params;
            if (rType === "spectrum") {
                that.$report = new SpectrumReport(params);
            } else if (rType === "loadDuration") {
                that.$report = new LoadDurationReport(params);
            } else if (rType === "averageProfile") {
                that.$report = new AverageProfileReport(params);
            } else if (rType === "aggregation") {
                that.$report = new AggregationReport(params);
            } else if (rType === "equipmentOperation") {
                that.$report = new EquipmentOperationReport(params);
            } else if (rType === "ranking") {
                that.$report = new RankingReport(params);
            } else if (rType === "relativeContribution") {
                that.$report = new RelativeContributionReport(params);
            }
            return that.$report.initialize(that.jq().find('div.rc')).then(function () {
                return report.getConfig().then(function (content) {
                    that.$report.properties().setValue("dashboardReportData", content.toString());
                    that.$report.load({}).then(function () {
                        that.register();
                    });
                });
            });
        });
    };

    /**
     * After destroying all child editors, removes the `PropertySheet` class
     * added in `initialize()`.
     *
     * @returns {Promise} promise to be resolved when all child editors
     * are destroyed and CSS classes are removed
     */
    AnalyticReportView.prototype.register = function () {
        var rep = this.value();
        this.$report.jq().on(reportWidgetEvents.REPORT_CONFIG_CHANGED, function (e, jsonData, metaData, ownerWidget) {
            return rep.invoke({
                slot: "saveConfig",
                value: baja.$("baja:String").make(JSON.stringify(jsonData))
            }).then(function () {
                return Promise.resolve(rep);
            }).catch(function (err) {
                if (err.javaClass === "javax.baja.security.PermissionException") {
                    if (ownerWidget) {
                        ownerWidget.showError(reportConstants.ERR_CODE_PERMISSION);
                    }
                }
                baja.outln(err);
            });
        });
    };

    return AnalyticReportView;
});
