/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/fe/ReportOptionalValueFE
 */
define(['baja!', 'jquery', 'underscore', 'Promise', 'bajaux/Widget', 'dialogs', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/FrozenEnumEditor', 'nmodule/webEditors/rc/fe/fe', 'hbs!nmodule/analytics/rc/chart/templates/fe/analyticOptionalValue', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/BooleanEditor', 'lex!analytics'], function (baja, $, _, Promise, Widget, dialogs, events, FrozenEnumEditor, fe, analyticOptionalValue, BaseEditor, BooleanEditor, lexicon) {

  'use strict';

  var lex = lexicon[0];
  /**
   * A field editor for selecting units for reports.
   *
   * @class
   * @alias module:nmodule/analytics/rc/report/fe/ReportOptionalValueFE
   * @extends module:nmodule/analytics/rc/chart/fe/AnalyticOptionalValueFE
   */
  var ReportOptionalValueFE = function ReportOptionalValueFE() {
    BaseEditor.call(this, arguments);
  };
  // Inheriting ReportOptionalValueFE from BaseEditor
  ReportOptionalValueFE.prototype = Object.create(BaseEditor.prototype);
  // Setting the constructor
  ReportOptionalValueFE.prototype.constructor = ReportOptionalValueFE;

  /**
   * Creates a text box with a Data selection picker.
   * The data selection picker has a list box that shows all the available
   * tags for the selected node or all tags in the station.
   *
   * It uses NiagaraRpc to retrieve data from station.
   * @param {jQuery} dom
   */
  ReportOptionalValueFE.prototype.doInitialize = function (dom) {
    var that = this;
    dom.html(analyticOptionalValue({
      label: that.getLabel()
    }));
    var feTextElement = that.$getDataElement(),
        feCheckboxElement = that.$getCheckboxElement();
    feCheckboxElement.prop('checked', that.isSelected());
    feCheckboxElement.change(function () {
      that.setModified(true);
      if (that.isSelected()) {
        feTextElement.val(that.value());
      } else {
        feTextElement.val('');
      }
    });
    feTextElement.on('click', function (obj) {
      if (that.$getCheckboxElement().val()) {
        dialogs.showOkCancel({
          title: that.getLabel(),
          content: function content(dlg, jq) {
            jq.html("<div class='feDiv'></div>");
            var v = that.value();
            v = v && v.value || v;
            if (_.isEmpty(v)) {
              v = that.getDefaultValue();
            }
            return fe.buildFor({
              dom: $(".feDiv", jq),
              type: that.getFEType(),
              value: v
            }).then(function (propertyEditor) {
              return that.handleDataPropertyFEChanged(propertyEditor);
            });
          }
        }).ok(function (obj) {
          that.setModified(true);
        }).cancel(function (obj) {});
      }
    });
    return BaseEditor.prototype.doInitialize.apply(that, arguments);
  };
  /**
   * Handle the property changed event
   */
  ReportOptionalValueFE.prototype.handleDataPropertyFEChanged = function (propertyEditor) {
    // Time to register events.
    var that = this;
    propertyEditor.jq().on(events.MODIFY_EVENT, function () {
      var value = propertyEditor.doRead();
      that.$getDataElement().val(that.getDataValue(value));
      that.$getDataElement().attr("tag", that.getDataTag(value));
    });
    return Promise.resolve();
  };

  /**
   * Loads a `baja.String` data value into the input element. I
   * @param {baja.String} value
   * @returns {Promise} promise to be resolved if the value is loaded,
   * or rejected if the `Data Value` could not be encoded to string
   */
  ReportOptionalValueFE.prototype.doLoad = function (value) {
    var props = this.properties();
    var dataValue = value;
    var selected = props.getValue("selected");
    // selected = (selected === null) ? true : selected;
    if (!_.isEmpty(dataValue) && _.isString(dataValue)) {
      dataValue = baja.$("analytics:Interval").make(dataValue);
    }
    return this.buildEditor(dataValue, selected);
  };

  /**
   * Reads the data value from the date input element and constructs a
   * `Data` from it.
   * @returns {String} the read `Data` value
   */
  ReportOptionalValueFE.prototype.doRead = function () {
    var val1 = this.$getDataElement().attr("tag");
    var isSelected = this.$getCheckboxElement().val();
    var typeSpec = this.value().getType().getTypeSpec();
    var ret = Promise.resolve(baja.$(typeSpec).make(val1 || "none"));
    this.properties().setValue("selected", isSelected);
    return ret;
  };

  /**
   * Build the editor for Optional Value FE
   */
  ReportOptionalValueFE.prototype.buildEditor = function (dataVal, selected) {
    var that = this;
    if (!_.isEmpty(dataVal)) {
      if (selected) {
        this.$getDataElement().val(this.getDataValue(dataVal));
      }
      this.$getDataElement().attr("tag", this.getDataTag(dataVal));
    } else {
      selected = false;
    }
    that.$getCheckboxElement().val(selected);
    return fe.buildFor({
      dom: $(".fe-checkbox", that.jq()),
      type: BooleanEditor,
      value: selected,
      properties: { trueText: " ", falseText: " " }
    }).then(function (propertyEditor) {
      // Time to register events.
      return propertyEditor.jq().on(events.MODIFY_EVENT, function () {
        var value = propertyEditor.doRead();
        that.$getCheckboxElement().val(value);
        return BaseEditor.prototype.doLoad.apply(that, arguments);
      });
    });
  };
  /**
   * Get the value of data from type
   * @returns {*|jQuery|HTMLElement}
   */
  ReportOptionalValueFE.prototype.getDataValue = function (value) {
    return value.toString();
  };

  /**
   * Get the value of data from type
   * @returns {*|jQuery|HTMLElement}
   */
  ReportOptionalValueFE.prototype.getDataTag = function (value) {
    return value.getTag();
  };

  /**
   * Loads a `baja.String` data value into the input element. I
   * @param {baja.String} value
   * @returns {Promise} promise to be resolved if the value is loaded,
   * or rejected if the `Data Value` could not be encoded to string
   */
  ReportOptionalValueFE.prototype.$getDataElement = function () {
    return $('.fe-text', this.jq());
  };
  /**
   * Get the checkbox element
   * @returns {*|jQuery|HTMLElement}
   */
  ReportOptionalValueFE.prototype.$getCheckboxElement = function () {
    return $(".fe-checkbox", this.jq());
  };

  ReportOptionalValueFE.prototype.getFEType = function () {
    return FrozenEnumEditor;
  };

  ReportOptionalValueFE.prototype.getDefaultValue = function () {
    return baja.$("analytics:Interval");
  };

  ReportOptionalValueFE.prototype.isSelected = function () {
    return $(".fe-checkbox input[type=checkbox]", this.jq()).is(":checked");
  };

  /**
   * Enables or disables the data input element.
   * @param {Boolean} enabled
   */
  ReportOptionalValueFE.prototype.doEnabled = function (enabled) {
    this.$getDataElement().prop('disabled', !enabled || this.isReadonly());
  };

  /**
   * Enables or disables the data input element.
   * @param {Boolean} readonly
   */
  ReportOptionalValueFE.prototype.doReadonly = function (readonly) {
    this.$getDataElement().prop('disabled', readonly || !this.isEnabled());
  };

  /**
   * Get the label for interval
   */
  ReportOptionalValueFE.prototype.getLabel = function () {
    return lex.get('interval');
  };

  return ReportOptionalValueFE;
});
