var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/fe/RawDataFilterEditor
 */
define(['baja!', 'baja!analytics:RawDataFilter', 'bajaux/Widget', 'bajaux/events', 'Promise', 'jquery', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor', 'nmodule/history/rc/fe/RolloverValueEditor', 'lex!analytics', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, types, Widget, events, Promise, $, ComplexCompositeEditor, RolloverValueEditor, lexs) {

  'use strict';

  var lex = lexs[0];

  var highLimitLabel = lex.getSafe('outlier.highLimit'),
      lowLimitLabel = lex.getSafe('outlier.lowLimit');
  var rawDataFilterEditor = function rawDataFilterEditor() {
    return '\n   <span class=\'HighLimit-label\' style="padding-right:0.2em;"><label>' + highLimitLabel + '</label></span>\n   <span class=\'HighLimit\' style="padding-right:2em"></span>\n   <span class=\'LowLimit-label\' style="padding-right:0.2em"><label>' + lowLimitLabel + '</label></span>\n   <span class=\'LowLimit\'></span>\n  ';
  };

  /**
   *  Baja UX field editor for Raw Data Field Editor
   *  It has two Rollover Value Editors to accept the user input.
   *  High Limit and Low limit is the limit beyond which the values will be filtered out.The text box accepts double values
   *  If the check box for high limit is checked then the text box gets disabled and high limit will not be applied
   *  If the check box for low limit is checked then the text box gets disabled and low limit will not be applied
   *
   * @class
   * @alias module:nmodule/analytics/rc/report/fe/RawDataFilterEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
   */

  var RawDataFilterEditor = function (_ComplexCompositeEdit) {
    _inherits(RawDataFilterEditor, _ComplexCompositeEdit);

    function RawDataFilterEditor() {
      _classCallCheck(this, RawDataFilterEditor);

      return _possibleConstructorReturn(this, (RawDataFilterEditor.__proto__ || Object.getPrototypeOf(RawDataFilterEditor)).apply(this, arguments));
    }

    _createClass(RawDataFilterEditor, [{
      key: 'doInitialize',
      value: function doInitialize(dom) {
        var _this2 = this;

        dom.addClass('RawDataFilterEditor');
        dom.html(rawDataFilterEditor());

        this.validators().add(function (value) {
          var val = _this2.value(),
              highVal = val.getHighLimit(),
              lowVal = val.getLowLimit();
          if (!highVal.getUnspecified() && !lowVal.getUnspecified()) {
            var highLimit = highVal.getValue();
            var lowLimit = lowVal.getValue();
            if (!isValid(highLimit, lowLimit)) {
              return Promise.reject(new Error(lex.get("outlier.limitError")));
            }
          }
        });
        return _get(RawDataFilterEditor.prototype.__proto__ || Object.getPrototypeOf(RawDataFilterEditor.prototype), 'doInitialize', this).apply(this, arguments);
      }

      /**
       * Initialize editors for the `HighLimit` and `LowLimit` slots.
       *
       * @returns {Array}
       */

    }, {
      key: 'getSlotFilter',
      value: function getSlotFilter() {
        return [{ slot: 'HighLimit', type: RolloverValueEditor }, { slot: 'LowLimit', type: RolloverValueEditor }];
      }

      /**
       * @overrides module:nmodule/webEditors/rc/fe/CompositeEditor
       * @returns {CompositeBuilder}
       */

    }, {
      key: 'makeBuilder',
      value: function makeBuilder() {
        var _this3 = this;

        var builder = _get(RawDataFilterEditor.prototype.__proto__ || Object.getPrototypeOf(RawDataFilterEditor.prototype), 'makeBuilder', this).apply(this, arguments);
        builder.getDomFor = function (key) {
          var jq = _this3.jq(),
              jqElement = jq;
          switch (key) {
            case 'HighLimit':
              return $('.HighLimit', jqElement);
            case 'LowLimit':
              return $('.LowLimit', jqElement);
            default:
              break;
          }
        };
        return builder;
      }

      /**
       * Reads the value of the value editor from the RolloverValue Editor.
       * @returns {Promise}
       */

    }, {
      key: 'doRead',
      value: function doRead() {
        var builder = this.getBuilder(),
            highLimitEd = builder.getEditorFor('HighLimit'),
            lowLimitEd = builder.getEditorFor('LowLimit');
        var highLimitVal = highLimitEd.value(),
            lowLimitVal = lowLimitEd.value();
        return Promise.join(highLimitEd.read(), lowLimitEd.read(), function (highLimitDiff, lowLimitDiff) {
          return Promise.join(highLimitDiff.apply(highLimitVal), lowLimitDiff.apply(lowLimitVal));
        });
      }
    }]);

    return RawDataFilterEditor;
  }(ComplexCompositeEditor);

  /**
   * Function is used to check if the highLimit is greater than the low Limit
   * @param {double} highLimit - high limit for raw data filter
   * @param {double} lowLimit - low limit for raw data filter
   * @returns {boolean}
   */


  function isValid(highLimit, lowLimit) {
    return highLimit >= lowLimit;
  }

  return RawDataFilterEditor;
});
