/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/fe/OptionSelector
 */
define(['baja!', 'lex!analytics', 'jquery', 'underscore', 'Promise', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/fe', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/analytics/rc/report/util/reportConstants', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, lexs, $, _, Promise, Widget, fe, events, BaseEditor, reportConstants) {
    'use strict';

    /**
     * A field editor to be used in Analytics module for selecting min, average and max color bands
     *
     * @class
     * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
     * @alias module:nmodule/analytics/rc/report/fe/OptionSelector
     */

    var OptionSelector = function OptionSelector(params) {
        BaseEditor.apply(this, arguments);
    };

    OptionSelector.prototype = Object.create(BaseEditor.prototype);

    OptionSelector.prototype.constructor = OptionSelector;

    /**
     * Creates the template for Option Selector.
     * @param {jQuery} dom
     */
    OptionSelector.prototype.doInitialize = function (dom) {
        var that = this;
        var props = this.properties(),
            optionList = props.getValue("options"),
            root = $("<div class='option-root'>").appendTo(dom); // Each of the options is expected to be a JSON with tag and display properties
        var id = "ov" + that.generateId();
        _.each(optionList, function (optItem) {
            var div = $("<div>").appendTo(root);
            var opt = $("<input type = 'radio'>").prop("value", optItem.tag).prop("name", id),
                display = $("<label>");
            display.prop("for", optItem.tag);
            display.addClass('chartValue-item-label');
            display.html(_.escape(optItem.display || optItem.tag));
            div.append(opt);
            div.append(display);
            root.append(div);
        });
        that.registerEvents();
        return BaseEditor.prototype.doInitialize.apply(this, arguments);
    };

    /**
     * Register event for click of radio button
     * @param val
     * @returns {*}
     */
    OptionSelector.prototype.registerEvents = function () {
        var that = this;
        var opt = $("input[type='radio']", this.jq());
        opt.click(function () {
            that.setModified(true);
        });
    };

    /**
     * Update the child editors
     */
    OptionSelector.prototype.doUpdate = function (props) {
        var that = this;
        var optionsList = props,
            labels = $("label", that.jq()),
            inputs = $("input[type='radio']", that.jq());
        _.each(optionsList, function (optItem, index) {
            var display = $(labels.get(index)),
                $input = $(inputs.get(index));
            display.prop("for", optItem.tag);
            display.html(_.escape(optItem.display || optItem.tag));
            $input.prop('value', optItem.tag);
        });
        return Promise.resolve(true);
    };
    /**
     * Set the selected value..
     */
    OptionSelector.prototype.doLoad = function (val) {
        var opt = $("input[value='" + val + "']", this.jq());
        opt.prop("checked", "checked");
        return BaseEditor.prototype.doLoad.apply(this, arguments);
    };

    /**
     * Set the selected value..
     */
    OptionSelector.prototype.doRead = function () {
        var opt = $("input[type='radio']:checked", this.jq());
        return Promise.resolve(opt.prop("value"));
    };

    return OptionSelector;
});
