/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * Created by E845876 on 5/2/2017.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/fe/DefaultNormalizationEditor
 */
define(['baja!', 'lex!analytics', 'jquery', 'Promise', 'underscore', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor', 'nmodule/webEditors/rc/fe/baja/BooleanEditor', 'baja!analytics:Normalization', 'nmodule/analytics/rc/report/fe/DegreeDayGroupMapEditor', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, lexs, $, Promise, _, Widget, feDialogs, ComplexCompositeEditor, BooleanEditor, types, DegreeDayGroupMapEditor) {
    'use strict';

    var lex = lexs[0];
    /**
     * A field editor for working with booleans.
     *
     * @class
     * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
     * @alias module:nmodule/analytics/rc/report/fe/DefaultNormalizationEditor
     */
    var DefaultNormalizationEditor = function DefaultNormalizationEditor(params) {
        ComplexCompositeEditor.call(this, $.extend({
            keyName: 'DefaultNormalizationEditor'
        }, params));
    };

    DefaultNormalizationEditor.prototype = Object.create(ComplexCompositeEditor.prototype);

    DefaultNormalizationEditor.prototype.constructor = DefaultNormalizationEditor;

    /**
     * Creates the template for the data tag editor
     * Makes an RPC call to station to get the available tags
     * @param {jQuery} dom
     */
    DefaultNormalizationEditor.prototype.doInitialize = function (dom) {
        dom.append('<span class="area-enabler"></span>');
        dom.append('<span class="area-node-mapping icon-icons-x16-add"></span>');

        this.registerEvents();
        return ComplexCompositeEditor.prototype.doInitialize.apply(this, arguments);
    };

    DefaultNormalizationEditor.prototype.getSlotFilter = function () {
        return [{
            slot: 'selected',
            type: BooleanEditor,
            properties: {
                trueText: lex.get('floorArea'),
                falseText: lex.get('floorArea')
            }
        }];
    };

    DefaultNormalizationEditor.prototype.makeBuilder = function () {
        var that = this;
        that.builder = ComplexCompositeEditor.prototype.makeBuilder.apply(that, arguments);

        that.builder.getDomFor = function (key) {
            var jq = that.jq();
            switch (key) {
                case 'selected':
                    return $('.area-enabler', jq);
            }
        };
        return that.builder;
    };

    /**
     * Register events for handling the mapping between groups and the rote node for
     * selecting 'Outside Air Temperature' for performing degree day normalization.
     */
    DefaultNormalizationEditor.prototype.registerEvents = function () {
        var jq = this.jq(),
            that = this;
        $('.area-node-mapping', jq).click(function (e) {
            var editor = that.getChildEditors()[0]; // Can assume safely that it points to enable/disable toggler
            editor.read().then(function (flag) {
                var val = that.$value;
                if (flag && val) {
                    var grpList = that.properties().getValue("groups");
                    return feDialogs.showFor({
                        type: DegreeDayGroupMapEditor,
                        title: lex.get('area.map.details.title'),
                        formFactor: "max",
                        properties: { groups: grpList },
                        value: val.getGroupMapping()
                    }).then(function (ret) {
                        // _.each(grpList, function (grp) {
                        //     grp.tag = grp.display;
                        // });
                    });
                }
            });
        });
    };

    /**
     * Update the properties
     */
    DefaultNormalizationEditor.prototype.doUpdate = function (groupList) {
        var that = this;
        that.properties().setValue("groups", groupList);
        return Promise.resolve(true);
    };

    return DefaultNormalizationEditor;
});
