/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/fe/ColorRangeEditor
 */
define(['baja!', 'lex!analytics', 'jquery', 'Promise', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/fe', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor', 'nmodule/webChart/rc/fe/color/ColorEditor', 'nmodule/analytics/rc/report/util/reportConstants', 'hbs!nmodule/analytics/rc/report/templates/UxColorRangeEditor', 'baja!analytics:ColorRange', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, lexs, $, Promise, Widget, fe, events, ComplexCompositeEditor, ColorEditor, reportConstants, UxColorRangeEditor, types) {
    'use strict';

    var lex = lexs[0];
    /**
     * A field editor to be used in Analytics module for selecting min, average and max color bands
     *
     * @class
     * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
     * @alias module:nmodule/analytics/rc/report/fe/ColorRangeEditor
     */
    var ColorRangeEditor = function ColorRangeEditor(params) {
        ComplexCompositeEditor.call(this, $.extend({
            keyName: 'ColorRangeEditor'
        }, params));
    };

    ColorRangeEditor.prototype = Object.create(ComplexCompositeEditor.prototype);

    ColorRangeEditor.prototype.constructor = ColorRangeEditor;

    ColorRangeEditor.prototype.getSlotFilter = function () {
        return [{ slot: 'minValueColor', type: ColorEditor }, { slot: 'avgValueColor', type: ColorEditor }, { slot: 'maxValueColor', type: ColorEditor }];
    };
    /**
     * Creates the template for Color Range Editor.
     * @param {jQuery} dom
     */
    ColorRangeEditor.prototype.doInitialize = function (dom) {
        dom.html(UxColorRangeEditor({
            minLabel: lex.get('minLabel'),
            avgLabel: lex.get('avgLabel'),
            maxLabel: lex.get('maxLabel')
        }));
        return ComplexCompositeEditor.prototype.doInitialize.apply(this, arguments);
    };
    /**
     * Make a custom builder for ColorRangeEditor which plugs-in
     * the root DOM for individual sub editors.
     * @returns {*}
     */
    ColorRangeEditor.prototype.makeBuilder = function () {
        var that = this,
            builder = ComplexCompositeEditor.prototype.makeBuilder.apply(that, arguments);

        builder.getDomFor = function (key) {
            var jq = that.jq(),
                elem = $(".color-range-container", jq);
            switch (key) {
                case 'minValueColor':
                    return $('.min-color-fe', elem);
                case 'avgValueColor':
                    return $('.avg-color-fe', elem);
                case 'maxValueColor':
                    return $('.max-color-fe', elem);
            }
        };
        return builder;
    };
    /**
     * @param config {JSON object containing min, average and max values
     * that can be updated to the DOM next to the color band.
     * @returns {*}
     */
    ColorRangeEditor.prototype.updateValues = function (config) {
        var min = config.min || '',
            avg = config.avg || '',
            max = config.max || '';
        this.updateValueForKey('minValueColor', min);
        this.updateValueForKey('avgValueColor', avg);
        this.updateValueForKey('maxValueColor', max);
    };
    /**
     * @param config {JSON object containing min, average and max values
     * that can be updated to the DOM next to the color band.
     * @returns {*}
     */
    ColorRangeEditor.prototype.updateValueForKey = function (key, value) {
        var that = this;
        var jq = that.jq(),
            elem = $(".color-range-container", jq);
        switch (key) {
            case 'minValueColor':
                $('.min-value', elem).html(value);break;
            case 'avgValueColor':
                $('.avg-value', elem).html(value);break;
            case 'maxValueColor':
                $('.max-value', elem).html(value);break;
        }
    };

    return ColorRangeEditor;
});
