/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * Created by E491819 on 5/9/2017.
 */
define(['baja!', 'lex!analytics', 'jquery', 'Promise', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/analytics/rc/report/fe/OrdChooserWithHierarchy', 'hbs!nmodule/analytics/rc/report/templates/UxAnalyticNodeSelector', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, lexs, $, Promise, Widget, fe, feDialogs, events, BaseEditor, OrdChooserWithHierarchy, UxAnalyticNodeSelector) {

    'use strict';

    var lex = lexs[0];

    /**
     * @path 'nmodule/analytics/rc/report/fe/AnalyticOrdChooser'
     * AnalyticOrdChooser field editor is used to select an ORD for use in/as analytic node
     * @param params
     * @constructor
     */
    var AnalyticOrdChooser = function AnalyticOrdChooser(params) {
        BaseEditor.apply(this, arguments);
    };

    AnalyticOrdChooser.prototype = Object.create(BaseEditor.prototype);

    AnalyticOrdChooser.prototype.constructor = AnalyticOrdChooser;

    /**
     * Creates the template for Analytic Data Tag Selector.
     * @param {jQuery} dom
     */
    AnalyticOrdChooser.prototype.doInitialize = function (dom) {
        dom.html(UxAnalyticNodeSelector({}));
        return BaseEditor.prototype.doInitialize.apply(this, arguments);
    };

    /**
     *  Load the value of the tag in to the text box.
     *  Register an event on the selection button
     * @param dom
     */
    AnalyticOrdChooser.prototype.doLoad = function (val) {
        var that = this;
        this.$getDataElement().val(val);
        if (!this.$registered) {
            return this.registerEvents(val).then(function () {
                that.$registered = true;
                return Promise.resolve(val);
            });
        } else {
            return Promise.resolve(val);
        }
    };

    /**
     * Returns the selected data tag
     * @returns {String} the selected data tag
     */
    AnalyticOrdChooser.prototype.doRead = function () {
        return this.$getDataElement().val();
    };

    /**
     * Register events for the tag chooser editor
     */
    AnalyticOrdChooser.prototype.registerEvents = function (val) {
        var that = this;
        var jq = that.jq();
        var de = this.$getDataElement();
        that.$lastVal = val;
        this.$offClickHandler();
        de.on("input propertychange paste", function () {
            that.setModified(that.doRead() !== that.$lastVal);
            that.$lastVal = that.doRead();
        });
        var feBase = {
            value: that.value(),
            type: OrdChooserWithHierarchy,
            formFactor: 'compact',
            title: lex.get("node.select.title")
        };
        jq.on('click', 'span.node-select-icon', function () {
            feDialogs.showFor($.extend(feBase, {
                progressCallback: function progressCallback(msg, arg) {}
            })).then(function (ord) {
                if (ord !== null) {
                    var ordStr = ord.encodeToString();
                    if (ordStr && ordStr.indexOf("station:|") === 0) {
                        ordStr = ordStr.slice(9);
                    }
                    that.$getDataElement().val(ordStr);
                    that.setModified(true);
                }
            }).finally(function () {});
        });
        return Promise.resolve(true);
    };

    /**
     * Unregister any event handlers
     * @param dom
     */
    AnalyticOrdChooser.prototype.doDestroy = function (dom) {
        this.$offClickHandler();
    };

    AnalyticOrdChooser.prototype.$offClickHandler = function () {
        var jq = this.jq();
        $("span.node-select-icon", jq).off();
        var de = this.$getDataElement();
        de.off();
        this.$registered = false;
    };
    /**
     * Get the reference to text box
     * @returns {*|jQuery|HTMLElement}
     */
    AnalyticOrdChooser.prototype.$getDataElement = function () {
        var jq = this.jq();
        return $(".nodeSelectValue", jq);
    };
    return AnalyticOrdChooser;
});
