/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'moment', 'dialogs', 'underscore', 'd3', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/analytics/rc/report/container/base/AnalyticsBaseReport', 'nmodule/analytics/rc/chart/loadduration/LoadDurationChart', 'nmodule/analytics/rc/table/AnalyticsBaseTable', 'lex!analytics', 'css!nmodule/js/rc/dialogs/dialogs'], function (baja, Widget, subscriberMixIn, Promise, $, moment, dialogs, _, d3, fe, feDialogs, AnalyticsBaseReport, LoadDurationChart, AnalyticsBaseTable, lexicon) {

    "use strict";

    var lex = lexicon[0];

    var LoadDurationReport = function LoadDurationReport(params) {
        AnalyticsBaseReport.apply(this, $.extend({}, params));
    };

    LoadDurationReport.prototype = Object.create(AnalyticsBaseReport.prototype);
    LoadDurationReport.prototype.constructor = LoadDurationReport;

    /**
     * Displa Average Profile Chart in this report
     * @returns {*}
     */
    LoadDurationReport.prototype.getChartType = function () {
        return LoadDurationChart;
    };

    LoadDurationReport.prototype.getTableType = function () {
        return AnalyticsBaseTable;
    };

    /**
     * Get the list of settings applicable for Average Profile Chart
     * @returns {*}
     */
    LoadDurationReport.prototype.getApplicableSettings = function () {
        var baseSettings = AnalyticsBaseReport.prototype.getApplicableSettings.apply(this, arguments);
        return $.extend(baseSettings, {
            dataTag: { req: true, value: "hs:power" },
            units: { req: true, value: "" },
            baseline: { req: true, value: { enabled: false } },
            normalization: {
                req: true, value: [{
                    type: 'area',
                    selected: false,
                    value: null
                }]
            },
            extras: { showColorSelector: true }
        });
    };

    /**
     * Overridden Report name
     */
    LoadDurationReport.prototype.getReportName = function () {
        return lex.get("report.loadduration");
    };

    /**
     * Returns the requirement of the report to aggregate the MultiNode or MultiOrd Requests.
     * @returns {boolean}
     */
    LoadDurationReport.prototype.getAggMode = function () {
        return true;
    };

    /**
     * Returns the report name
     * @returns {string}
     */
    LoadDurationReport.prototype.getName = function () {
        return "LoadDurationReport";
    };

    LoadDurationReport.prototype.showLegend = function () {
        return true;
    };

    /**
     * Some child reports might support multi part rollup and data tags.
     * @returns {boolean}
     */
    LoadDurationReport.prototype.isMultiPartSupported = function () {
        return false;
    };

    /**
     * Format the X Value
     * @returns {Function}
     */
    LoadDurationReport.prototype.getTableKeyFormatter = function () {
        var that = this;
        return function (xVal, key) {
            if (key === 'date') {
                var relTime = baja.$("baja:RelTime").make(xVal);
                var temp = { "sortValue": xVal };
                temp.value = relTime.getDaysPart() * 24 + relTime.getHoursPart() + "h  " + relTime.getMinutesPart() + "m";
                return temp;
            }
            return AnalyticsBaseReport.prototype.getTableKeyFormatter.apply(that)(xVal, key);
        };
    };

    /**
     * This aggregates the data for Aggregation report
     * @param chartDataModel
     * @param source
     */
    LoadDurationReport.prototype.processDataForTable = function (chart, source) {
        var grpArray = [],
            processedSeriesList = chart.series,
            modelList = chart.getModel();
        _.each(processedSeriesList, function (processedSeries, index) {
            var data = processedSeries.data,
                model = modelList[index];
            var inMemArr = [];
            _.each(data, function (dataItem, index1) {
                var inObj = {};
                if (index === 0) {
                    inObj.x = dataItem.x;
                    inObj.y = dataItem.y;
                }
                inObj[model.getSeriesName()] = dataItem.y;
                inObj.date = dataItem.x;
                inObj[model.getSeriesName() + "interpolationStatus"] = dataItem.metaData.interpolationStatus;
                inMemArr.push(inObj);
            });
            grpArray.push(inMemArr);
        });

        var consolidatedObjects = [];
        var trendCount = grpArray.length;
        if (trendCount > 0) {
            var recordCount = grpArray[0].length;
            _.each(grpArray, function (grp) {
                if (grp.length > recordCount) {
                    recordCount = grp.length;
                }
            });
            for (var i = 0; i < recordCount; i++) {
                var obj = {};
                for (var j = 0; j < trendCount; j++) {
                    for (var key in grpArray[j][i]) {
                        if (key) {
                            obj[key] = grpArray[j][i][key];
                        }
                    }
                }
                consolidatedObjects.push(obj);
            }
        }
        return consolidatedObjects;
    };
    return LoadDurationReport;
});
