/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'moment', 'dialogs', 'underscore', 'd3', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/analytics/rc/report/container/base/AnalyticsBaseReport', 'nmodule/analytics/rc/chart/averageprofile/AverageProfileChart', 'nmodule/analytics/rc/table/AnalyticsBaseTable', 'nmodule/analytics/rc/util/analyticsUtil', 'lex!analytics', 'css!nmodule/js/rc/dialogs/dialogs'], function (baja, Widget, subscriberMixIn, Promise, $, moment, dialogs, _, d3, fe, feDialogs, AnalyticsBaseReport, AverageProfileChart, AnalyticsBaseTable, analyticsUtil, lexicon) {

  "use strict";

  var lex = lexicon[0];

  var AverageProfileReport = function AverageProfileReport(params) {
    AnalyticsBaseReport.apply(this, $.extend({}, params));
  };

  AverageProfileReport.prototype = Object.create(AnalyticsBaseReport.prototype);
  AverageProfileReport.prototype.constructor = AverageProfileReport;

  /**
   * Displays Average Profile Chart in this report
   * @returns {*}
   */
  AverageProfileReport.prototype.getChartType = function () {
    return AverageProfileChart;
  };

  AverageProfileReport.prototype.getTableType = function () {
    return AnalyticsBaseTable;
  };

  /**
   * Get the list of settings applicable for Average Profile Chart
   * @returns {*}
   */
  AverageProfileReport.prototype.getApplicableSettings = function () {
    var baseSettings = AnalyticsBaseReport.prototype.getApplicableSettings.apply(this, arguments);
    return $.extend(baseSettings, {
      interval: { req: true, value: "fifteenMinutes", selected: true },
      dataTag: { req: true, value: "hs:power" },
      units: { req: true, value: "" },
      baseline: { req: true, value: { enabled: false } },
      normalization: { req: true, value: [{
          type: 'area',
          selected: false,
          value: null
        }, {
          type: 'degreeday',
          selected: false,
          value: 65,
          unit: 1
        }] },
      extras: { showColorSelector: true }
    });
  };

  /**
   * Overridden Report name
   */
  AverageProfileReport.prototype.getReportName = function () {
    return lex.get("report.averageprofile");
  };
  /**
   * Returns the requirement of the report to aggregate the MultiNode or MultiOrd Requests.
   * @returns {boolean}
   */
  AverageProfileReport.prototype.getAggMode = function () {
    return true;
  };

  /**
   * Returns the report name
   * @returns {string}
   */
  AverageProfileReport.prototype.getName = function () {
    return "AverageProfileReport";
  };

  AverageProfileReport.prototype.showLegend = function () {
    return true;
  };

  /**
   * This aggregates the data for Aggregation report
   * @param chartDataModel
   * @param source
   */
  AverageProfileReport.prototype.processDataForTable = function (chart, source) {
    var temp = {},
        processedSeriesList = chart.series;
    for (var i = 0; i < processedSeriesList.length; i++) {
      var currentSeries = processedSeriesList[i],
          seriesData = currentSeries.data;
      for (var j = 0; j < seriesData.length; j++) {
        var dateRef = seriesData[j].x;
        if (!temp[dateRef]) {
          temp[dateRef] = { date: dateRef, x: dateRef };
        }
        temp[dateRef][currentSeries.name] = seriesData[j].y;
        temp[dateRef][currentSeries.name + "interpolationStatus"] = seriesData[j].metaData.interpolationStatus;
        // temp[dateRef]['y'] = seriesData[j].y;
      }
    }
    var ret = _.map(temp, function (value, key) {
      return value;
    });
    return ret;
  };

  /**
   * Format the X Value
   * @returns {Function}
   */
  AverageProfileReport.prototype.getTableKeyFormatter = function () {
    var that = this;
    return function (xVal, key) {
      if (key === 'date') {
        var relTime = baja.RelTime.make(xVal);
        return analyticsUtil.formatHHMMSS(relTime.getHoursPart(), relTime.getMinutesPart(), relTime.getSecondsPart(), "chart.avgprofile.xaxis.fmt.sec");
      }
      return AnalyticsBaseReport.prototype.getTableKeyFormatter.apply(that)(xVal, key);
    };
  };

  return AverageProfileReport;
});
