/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/base/AnalyticReportFullConfigEditor
 */
define(['baja!', 'lex!analytics', 'jquery', 'Promise', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'bajaux/events', 'underscore', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor', 'nmodule/analytics/rc/report/base/AnalyticReportConfigItemEditor', 'hbs!nmodule/analytics/rc/report/templates/UxReportFullConfigurationEditor', 'nmodule/analytics/rc/report/util/reportConstants', 'nmodule/analytics/rc/report/util/reportWidgetEvents', 'baja!analytics:AnalyticCompositeConfiguration,analytics:AnalyticReportConfiguration,analytics:AnalyticConfigurationItem,analytics:AnalyticReportTimeRange', 'css!nmodule/analytics/rc/report/styles/uxstyles', 'css!nmodule/analytics/rc/report/styles/reportStyles'], function (baja, lexs, $, Promise, Widget, subscriberMixIn, fe, feDialogs, events, _, ComplexCompositeEditor, AnalyticReportConfigItemEditor, UxReportFullConfigurationEditor, reportConstants, reportWidgetEvents, types) {
  'use strict';

  var lex = lexs[0];
  /**
   * A field editor to be used in Analytics module for configuring all report
   * related parameters
   *
   * @class
   * @alias module:nmodule/analytics/rc/report/base/AnalyticReportFullConfigEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
   */
  var AnalyticReportFullConfigEditor = function AnalyticReportFullConfigEditor(params) {
    ComplexCompositeEditor.call(this, $.extend({
      keyName: 'AnalyticReportFullConfigEditor'
    }, params));
    subscriberMixIn(this);
  };

  AnalyticReportFullConfigEditor.prototype = Object.create(ComplexCompositeEditor.prototype);

  AnalyticReportFullConfigEditor.prototype.constructor = AnalyticReportFullConfigEditor;

  /**
   * Get the list of slots to be displayed
   * @param value
   */
  AnalyticReportFullConfigEditor.prototype.getSlotFilter = function (value) {
    var slotList = [];
    var jq = this.jq();

    var dataTagConfig = value.getDataTag();
    if (dataTagConfig.getPropertyRequired()) {
      $(".datatag-fe", jq).show();
      slotList.push({ slot: "dataTag", type: AnalyticReportConfigItemEditor });
    } else {
      $(".datatag-fe", jq).hide();
    }

    // Now add more slots based on their "required" status
    // Interval
    var intervalConfig = value.getInterval();
    if (intervalConfig.getPropertyRequired()) {
      $(".interval-fe", jq).show();
      slotList.push({ slot: "interval", type: AnalyticReportConfigItemEditor,
        properties: {
          selected: intervalConfig.getSelected()
        } });
    } else {
      $(".interval-fe", jq).hide();
    }

    // Roll up
    var rollupConfig = value.getRollup();
    if (rollupConfig.getPropertyRequired()) {
      $(".rollup-fe", jq).show();
      slotList.push({ slot: "rollup", type: AnalyticReportConfigItemEditor,
        properties: {
          selected: rollupConfig.getSelected(),
          propName: "rollup"
        } });
    } else {
      $(".rollup-fe", jq).hide();
    }

    // Aggregation
    var aggregationConfig = value.getAggregation();
    if (aggregationConfig.getPropertyRequired()) {
      $(".aggregation-fe", jq).show();
      slotList.push({ slot: "aggregation", type: AnalyticReportConfigItemEditor,
        properties: {
          selected: aggregationConfig.getSelected(),
          propName: "aggregation"
        } });
    } else {
      $(".aggregation-fe", jq).hide();
    }

    // Units
    var unitsConfig = value.getUnits();
    if (unitsConfig.getPropertyRequired()) {
      $(".units-fe", jq).show();
      slotList.push({ slot: "units", type: AnalyticReportConfigItemEditor });
    } else {
      $(".units-fe", jq).hide();
    }

    // Data Filter
    var dfConfig = value.getDataFilter();
    if (dfConfig.getPropertyRequired()) {
      $(".dataFilter-fe", jq).show();
      slotList.push({ slot: "dataFilter", type: AnalyticReportConfigItemEditor });
    } else {
      $(".dataFilter-fe", jq).hide();
    }

    // Data Combination Map
    if (_.isFunction(value.getRollupDataTagMap)) {
      var dcmConfig = value.getRollupDataTagMap();
      if (dcmConfig.getPropertyRequired()) {
        $(".dataCombinationMap-fe", jq).show();
        slotList.push({ slot: "rollupDataTagMap", type: AnalyticReportConfigItemEditor });
      } else {
        $(".dataCombinationMap-fe", jq).hide();
      }
    } else {
      $(".dataCombinationMap-fe", jq).hide();
    }

    // Missing data algorithm parameters.
    var mdcConfig = value.getMissingDataStrategy();
    if (mdcConfig.getPropertyRequired()) {
      $(".missingDataConfigMap-fe", jq).show();
      slotList.push({ slot: "missingDataStrategy", type: AnalyticReportConfigItemEditor });
    } else {
      $(".missingDataConfigMap-fe", jq).hide();
    }

    // His totalization parameters.
    var hisTotEnabled = value.getHisTotEnabled();
    if (hisTotEnabled.getPropertyRequired()) {
      $(".hisTotEnabled-fe", jq).show();
      slotList.push({ slot: "hisTotEnabled", type: AnalyticReportConfigItemEditor });
    } else {
      $(".hisTotEnabled-fe", jq).hide();
    }

    //interpolationStatus parameters
    var interpolationStatus = value.getInterpolationStatus();
    if (interpolationStatus.getPropertyRequired()) {
      $(".interpolationStatus-fe", jq).show();
      slotList.push({ slot: "interpolationStatus", type: AnalyticReportConfigItemEditor });
    } else {
      $(".interpolationStatus-fe", jq).hide();
    }

    // Legend position parameters.
    var legendPosition = value.getLegendPosition();
    if (legendPosition.getPropertyRequired()) {
      $(".legendPosition-fe", jq).show();
      slotList.push({ slot: "legendPosition", type: AnalyticReportConfigItemEditor });
    } else {
      $(".legendPosition-fe", jq).hide();
    }
    return slotList;
  };
  /**
   * Creates the template for Color Range Editor.
   * @param {jQuery} dom
   */
  AnalyticReportFullConfigEditor.prototype.doInitialize = function (dom) {
    dom.html(UxReportFullConfigurationEditor({
      dataTagLabel: lex.get("report.settings.dataTagLabel"),
      timeRangeLabel: lex.get("report.settings.timeRangeLabel"),
      intervalLabel: lex.get("report.settings.intervalLabel"),
      rollupLabel: lex.get("report.settings.rollupLabel"),
      aggregationLabel: lex.get("report.settings.aggregationLabel"),
      unitsLabel: lex.get("report.settings.unitsLabel"),
      dataFilterLabel: lex.get("report.settings.dataFilterLabel"),
      dataCombinationMapLabel: lex.get("report.settings.dataCombinationMapLabel"),
      hisTotEnabledLabel: lex.get("report.settings.hisTotEnabledLabel"),
      legendPositionLabel: lex.get("report.settings.legendPositionLabel"),
      interpolationStatus: lex.get("report.settings.interpolationStatusLabel"),
      missingDataConfigMapLabel: lex.get("report.settings.mdcMapLabel")
    }));
    //TODO: remove this when NCCB-30798 is resolved
    dom.on(events.MODIFY_EVENT, '.type-baja-Unit > .unit', function (e, ed) {
      var unitEd = $(this).closest('.type-baja-Unit').data('widget');
      unitEd.setModified(true);
      return false;
    });
    return ComplexCompositeEditor.prototype.doInitialize.apply(this, arguments);
  };

  /**
   * Make a custom builder for ColorRangeEditor which plugs-in
   * the root DOM for individual sub editors.
   * @returns {*}
   */
  AnalyticReportFullConfigEditor.prototype.makeBuilder = function () {
    var that = this,
        builder = ComplexCompositeEditor.prototype.makeBuilder.apply(that, arguments);

    builder.getDomFor = function (key) {
      var jq = that.jq(),
          elem = jq;
      switch (key) {
        case 'dataTag':
          return $('.datatag-fe-content', elem);
        case 'timeRange':
          return $('.timerange-fe-content', elem);
        case 'interval':
          return $('.interval-fe-content', elem);
        case 'rollup':
          return $('.rollup-fe-content', elem);
        case 'aggregation':
          return $('.aggregation-fe-content', elem);
        case 'units':
          return $('.units-fe-content', elem);
        case 'dataFilter':
          return $('.dataFilter-fe-content', elem);
        case 'missingDataStrategy':
          return $('.mdcConfigMap-fe-content', elem);
        case 'hisTotEnabled':
          return $('.hisTotEnabled-fe-content', elem);
        case 'interpolationStatus':
          return $('.interpolationStatus-fe-content', elem);
        case 'legendPosition':
          return $('.legendPosition-fe-content', elem);
        case 'rollupDataTagMap':
          return $('.dataCombinationMap-fe-content', elem);
        default:
          break;
      }
    };
    return builder;
  };

  AnalyticReportFullConfigEditor.prototype.doRead = function () {
    return ComplexCompositeEditor.prototype.doRead.apply(this, arguments).then(function (complexDiff) {
      return Promise.resolve(complexDiff);
    });
  };
  /**
   * Set Modified by enabling/disabling the 'Run Report' button
   * @param flag
   * @returns {*}
   */
  AnalyticReportFullConfigEditor.prototype.setModified = function (flag) {
    var btn = $(".submit-section", this.jq()).find("button");
    if (flag) {
      btn.prop('disabled', false);
    }
  };
  /**
   * Validate
   */
  AnalyticReportFullConfigEditor.prototype.validate = function () {
    return Promise.resolve(true);
  };

  return AnalyticReportFullConfigEditor;
});
