/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * Created by e877411 on 10/21/2016.
 */

define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'jquery', 'd3', 'underscore', 'nmodule/analytics/rc/chart/types/AnalyticChartType'], function (baja, Widget, subscriberMixIn, $, d3, _, AnalyticChartType) {

  "use strict";

  /**
   * @constructor
   * Base view for all web analytics charts
   */

  var AnalyticD3PieChart = function AnalyticD3PieChart(params) {
    AnalyticChartType.apply(this, params);
    //subscriberMixIn(this);
  };
  // Inheriting Analytics Base Chart from AnalyticD3BaseChart
  AnalyticD3PieChart.prototype = Object.create(AnalyticChartType.prototype);
  // Setting the constructor
  AnalyticD3PieChart.prototype.constructor = AnalyticD3PieChart;

  /**
   * Render the pie
   * @param chartSettingsCollection
   */
  AnalyticD3PieChart.prototype.reDraw = function (chartSettingsCollection) {
    this.draw(chartSettingsCollection);
  };

  /**
   * Render the pie
   * @param chartSettingsCollection
   */

  //svg, series, xScale, yScale, width, height
  AnalyticD3PieChart.prototype.draw = function (baseChart, series) {
    var posObj = {};
    var radiusX = baseChart.availableWidth() * 0.45,
        radiusY = baseChart.availableHeight() * 0.45; // 90% of outer div width and 90% height
    var radius = radiusX < radiusY ? radiusX : radiusY;

    //need to add margin
    var cX = radiusX + baseChart.chartMargins().left,
        cY = radiusY + baseChart.chartMargins().top;
    var svg = baseChart.svg();
    svg.attr("transform", "translate(" + cX + "," + cY + ")");

    // Take 80 % of width and height
    var arc = d3.svg.arc().outerRadius(radius);

    var pie = d3.layout.pie().value(function (d, i) {
      return d.y;
    }).sort(null).startAngle(90 * (Math.PI / 180)) // If you change this, then you have to adjust the label & line positioning below.
    .endAngle(450 * (Math.PI / 180)); // If you change this, then you have to adjust the label & line positioning below.

    var pieData = pie(series.map(function (e) {
      e.x = e.data[0].x;
      e.y = e.data[0].y;
      return e;
    }));
    var paths = svg.selectAll('path').data(pieData).enter().append('path').attr('d', arc).attr('fill', function (d, i) {
      return d.data.color;
    });

    // debugValue to support the sanity testing, should be enabled through analyticService.
    if (baseChart.isDebugEnabled) {
      d3.selectAll('path').attr('debugValue', function (d) {
        return d.data.x + ";" + d.data.y + (["null", undefined].contains(d.data.unitSymbol) ? "" : ";" + d.data.unitSymbol);
      });
    }

    var outerArc = d3.svg.arc().innerRadius(radius * 0.9).outerRadius(radius * 0.9);

    var text = svg.selectAll("text").data(pieData);

    text.enter().append("text").attr("dy", ".35em").attr("style", "font-size:" + baseChart.getTabConfigDataModel().getFontSize() + "px").text(function (d) {
      return baseChart.getSeriesLabel(d);
    });

    function midAngle(d) {
      return d.startAngle + (d.endAngle - d.startAngle) / 2;
    }

    // Tween transition for text labels.
    text.transition().duration(1000).attrTween("transform", function (d) {
      this._current = this._current || d;
      var interpolate = d3.interpolate(this._current, d);
      this._current = interpolate(0);
      return function (t) {
        var d2 = interpolate(t);
        var pos = outerArc.centroid(d2);
        pos[0] *= 1.26; //radius * (midAngle(d2) < Math.PI ? 1 : -1);
        pos[1] *= 1.15;
        posObj[d.data.random] = pos;
        // posObj[d.data.name + ":" + d.data.color] = pos;
        return "translate(" + pos + ")";
      };
    }).attrTween("text-anchor", function (d) {
      this._current = this._current || d;
      var interpolate = d3.interpolate(this._current, d);
      this._current = interpolate(0);
      return function (t) {
        var d2 = interpolate(t);
        return midAngle(d2) >= 2 * Math.PI || midAngle(d2) < Math.PI ? "start" : "end"; // The change said above has to be done here.
      };
    });

    text.exit().remove();

    var polyline = svg.selectAll("polyline").data(pieData);

    polyline.enter().append("polyline");

    // Tween transition for poly lines begin.
    polyline.transition().duration(1000).attrTween("points", function (d) {
      this._current = this._current || d;
      var interpolate = d3.interpolate(this._current, d);
      this._current = interpolate(0);
      return function (t) {
        var d2 = interpolate(t);

        var inner = outerArc.centroid(d2);
        inner[0] *= 1.05;
        inner[1] *= 1.05;

        var outer = outerArc.centroid(d2);
        outer[0] *= 1.15;
        outer[1] *= 1.15;

        var pos = outerArc.centroid(d2);
        pos[0] *= 1.25; //radius * 0.95 * (midAngle(d2) < Math.PI ? 1 : -1);
        pos[1] *= 1.15;

        return [inner, outer, pos];
      };
    }).attr("style", function (d) {
      return "fill:none;opacity: .9;stroke:" + d.data.color + ";stroke-width: 2px;";
    });

    polyline.exit().remove();

    // This function, handles the relaxation part of labels and lines.
    var relaxLabelsAndLines = function relaxLabelsAndLines() {
      var a, b, da, db, y1, y2, deltaY, sign, adjust, transformDa, transformDb;
      text.each(function (d, i) {
        a = this;
        da = d3.select(a);
        transformDa = da.attr("transform");
        transformDa = transformDa.split(",");
        y1 = transformDa[1].split(")")[0];
        text.each(function (d, j) {
          b = this;
          if (a === b) {
            return;
          }
          db = d3.select(b);
          if (da.attr("text-anchor") !== db.attr("text-anchor")) {
            return;
          }
          transformDb = db.attr("transform");
          transformDb = transformDb.split(",");
          y2 = transformDb[1].split(")")[0];
          deltaY = y1 - y2;

          if (Math.abs(deltaY) > 30) {
            return;
          }

          sign = deltaY > 0 ? 3 : -3;
          adjust = sign * 0.85;
          da.attr("transform", "translate(" + transformDa[0].split("(")[1] + "," + (+y1 + adjust) + ")");
          db.attr("transform", "translate(" + transformDb[0].split("(")[1] + "," + (+y2 - adjust) + ")");
          var indexValue = da.data()[0].data.name + ":" + da.data()[0].data.color;
          posObj[indexValue] = [transformDa[0].split("(")[1], +y1 + adjust];
          posObj[indexValue] = [transformDb[0].split("(")[1], +y2 - adjust];
        });
      });

      var daReturn, angleDa;
      polyline.each(function (d, i) {
        a = this;
        da = d3.select(a);
        transformDa = da.attr("points").split(",");

        transformDa = _.map(transformDa, function (val) {
          return parseFloat(val);
        });

        angleDa = Math.abs((transformDa[3] - transformDa[1]) / (transformDa[2] - transformDa[0]));

        if (angleDa >= 0 && angleDa <= 0.1) {
          return;
        }

        transformDa[4] = posObj[d.data.random][0] * 0.99;
        transformDa[5] = posObj[d.data.random][1]; //+(3*(posObj[d.data.x][1]/Math.abs(posObj[d.data.x][1])));
        transformDa[3] = transformDa[5];
        var signIda = transformDa[2] / Math.abs(transformDa[2]);
        transformDa[2] = Math.abs((transformDa[3] - transformDa[1]) / angleDa) * signIda + transformDa[0];

        daReturn = _.reduce(transformDa, function (initialVal, element) {
          return initialVal + "," + element;
        }, "");
        da.attr("points", daReturn.substring(1));
      });
    };

    setTimeout(relaxLabelsAndLines, 2000);

    return paths;
  };

  return AnalyticD3PieChart;
});
