/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * @file: This file represents the settings window for the Web analytic charts
 * @author Upender Paravastu & Sai Komaravolu
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'moment', 'underscore', 'dialogs', 'bajaux/events', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/analytics/rc/chart/fe/AnalyticUxConfigurationSettingsFE', 'nmodule/analytics/rc/chart/fe/ColumnListFE', 'hbs!nmodule/analytics/rc/chart/templates/fe/analyticTableConfiguration', 'lex!baja,analytics'], function (baja, Widget, subscriberMixIn, Promise, $, moment, _, dialogs, events, fe, feDialogs, AnalyticUxConfigurationSettingsFE, ColumnListFE, analyticTableConfiguration, lexicon) {

  "use strict";

  var lex = lexicon[1];
  /**
   * A field editor for working with Settings of chart widget.
   *
   * @class
   * @extends module:nmodule/analytics/rc/chart/fe/AnalyticUxConfigurationSettingsFE
   * @alias module:analytics/rc/chart/fe/AnalyticUxWebChartSettingsFE
   */
  var TableConfigurationSettingsFE = function TableConfigurationSettingsFE() {
    AnalyticUxConfigurationSettingsFE.apply(this, arguments);
  };
  // Inheriting AnalyticUxWebChartSettingsFE from BaseEditor
  TableConfigurationSettingsFE.prototype = Object.create(AnalyticUxConfigurationSettingsFE.prototype);
  //Setting the constructor
  TableConfigurationSettingsFE.prototype.constructor = TableConfigurationSettingsFE;

  /**
   *
   * @param dom
   * include: "<tr class='ux-table-row'> <td> <label>Show On/Off</label>  </td> <td> <div class='onOffFE'></div> </td> </tr>"}
   */
  TableConfigurationSettingsFE.prototype.getFields = function (obj) {
    obj.include = analyticTableConfiguration({ columnList: lex.get("columnList") });
    return obj;
  };

  /**
   * Build Field Editors
   * @param settingsObj
   * @returns {Array Promise}
   */
  TableConfigurationSettingsFE.prototype.initFieldEditors = function (settingsObj) {
    var that = this;
    var arr = AnalyticUxConfigurationSettingsFE.prototype.initFieldEditors.apply(that, [settingsObj]);
    arr.push({
      dom: $(".columnListFE", that.jq()),
      type: ColumnListFE,
      properties: { "columnList": settingsObj.getColumnList() },
      value: settingsObj.getExclusionList(),
      formFactor: 'mini',
      keyName: "exclusionList"
    });
    return arr;
  };

  return TableConfigurationSettingsFE;
});
