/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webChart/rc/fe/StartEndTimeRangeEditor
 */
define(['baja!', 'jquery', 'Promise', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor', 'nmodule/webEditors/rc/fe/fe', 'bajaux/events', 'bajaux/Widget', 'moment', 'hbs!nmodule/analytics/rc/chart/templates/fe/startEndTimeRangeEditor', 'nmodule/analytics/rc/chart/fe/TimeRangeStringLabelEditor', 'baja!' + 'baja:AbsTime,' + 'baja:AbsTimeRange,' + 'baja:TimeRange,' + 'baja:Time,' + 'baja:Weekday,' + 'bql:DynamicTimeRangeType,' + 'analytics:TimeRangeStringLabel'], function (baja, $, Promise, ComplexCompositeEditor, fe, events, Widget, moment, startEndTimeRangeEditor, TimeRangeStringLabelEditor, types) {
  "use strict";

  /**
   * A StartEndTimeRangeEditor is the editor for webChart:WebChartTimeRangEditor.
   *
   * @class
   * @alias module:nmodule/webChart/rc/fe/StartEndTimeRangeEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
   */

  var StartEndTimeRangeEditor = function StartEndTimeRangeEditor(params) {
    ComplexCompositeEditor.apply(this, arguments);
  };
  StartEndTimeRangeEditor.prototype = Object.create(ComplexCompositeEditor.prototype);
  StartEndTimeRangeEditor.prototype.constructor = StartEndTimeRangeEditor;

  /**
   * Return all the properties of the WebChartTimeRange
   * @returns {string[]}
   */
  StartEndTimeRangeEditor.prototype.getSlotFilter = function () {
    return [{ slot: 'start', type: TimeRangeStringLabelEditor }, 'startTime', { slot: 'end', type: TimeRangeStringLabelEditor }, 'endTime'];
  };
  /**
   * Implement do save
   * @param value
   * @param params
   */
  StartEndTimeRangeEditor.prototype.doSave = function (value, params) {
    var that = this;
    ComplexCompositeEditor.prototype.doSave.call(this, value, params);
    var chartTimeRange = baja.$('analytics:AnalyticChartTimeRange', {
      startTime: that.getBuilder().getValueFor("startTime"),
      endTime: that.getBuilder().getValueFor("endTime")
    });
    value = chartTimeRange;
    return Promise.resolve(value);
  };

  StartEndTimeRangeEditor.prototype.$buildSubEditorDom = function (key) {
    var jq = this.jq(),
        dom = $('.js-' + key, jq);
    return dom;
  };

  /**
   * initialize the dom and register all event handlers
   * @param {jQuery} dom
   */
  StartEndTimeRangeEditor.prototype.doInitialize = function (dom) {
    var that = this;
    var div = $("<div></div>");
    div.html(startEndTimeRangeEditor());
    that.jq().append(div);
    //doing this last allows squelching of the premature modify event
    return ComplexCompositeEditor.prototype.doInitialize.apply(this, arguments);
  };

  /**
   * Load the current value and setup any dependant slot interactions
   * @returns {Promise|*}
   * @param value {baja.Value}
   */
  StartEndTimeRangeEditor.prototype.doLoad = function (value) {
    return Promise.resolve(ComplexCompositeEditor.prototype.doLoad.apply(this, arguments));
  };
  /**
   * register this editor automatically if the file is included
   * @inner
   */
  // function register() {
  //   fe.register('analytics:TimeRangeStringLabel',
  //       'nmodule/analytics/rc/chart/fe/TimeRangeStringLabelEditor');
  // }
  //
  // register();

  return StartEndTimeRangeEditor;
});
