/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * @file: This file represents the settings window for the Web analytic charts
 * @author Upender Paravastu & Sai Komaravolu
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'moment', 'dialogs', 'underscore', 'bajaux/events', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/BooleanEditor', 'hbs!nmodule/analytics/rc/chart/templates/fe/analyticTableConfiguration', 'lex!baja,analytics'], function (baja, Widget, subscriberMixIn, Promise, $, moment, dialogs, _, events, fe, feDialogs, BaseEditor, BooleanEditor, analyticTableConfiguration, lexicon) {

  "use strict";

  /**
   * A field editor for working with Settings of chart widget.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:analytics/rc/chart/fe/AnalyticUxWebChartSettingsFE
   */

  var ColumnListFE = function ExclusionListFE(params) {
    BaseEditor.call(this, $.extend({ keyName: "ColumnListFE" }, params));
  };
  // Inheriting AnalyticUxWebChartSettingsFE from BaseEditor
  ColumnListFE.prototype = Object.create(BaseEditor.prototype);
  //Setting the constructor
  ColumnListFE.prototype.constructor = ColumnListFE;

  /**
   *
   * @param dom
   */
  ColumnListFE.prototype.doInitialize = function (dom) {
    var that = this;
    var columnList = that.properties().getValue("columnList");
    columnList = columnList.split(",");
    var jq = that.jq();
    return Promise.all(_.map(columnList, function (column, index) {
      return fe.buildFor({
        dom: $('<span class="column' + column + index + '"/><br>').appendTo(jq),
        value: column,
        type: BooleanEditor,
        properties: {
          trueText: column.capitalizeFirstLetter(),
          falseText: column.capitalizeFirstLetter()
        },
        formFactor: 'mini'
      }).then(function (editor) {
        editor.jq().find("input").attr("style", "margin-right:5px;");
      });
    }));
  };

  /**
   *
   * @param feObj
   */
  ColumnListFE.prototype.doLoad = function (feObj) {
    var that = this;
    var exclusionArray = feObj.split(",");
    return Promise.all(_.map(that.getChildEditors(), function (editor, index) {
      if (exclusionArray.contains(editor.properties().getValue("trueText"))) {
        return editor.load(false);
      }
    }));
  };

  /**
   *
   * @returns {Array}
   */
  ColumnListFE.prototype.doRead = function () {
    var returnValue = [];
    _.each(this.getChildEditors(), function (editor, index) {
      if (!editor.doRead() && !returnValue.contains(editor.properties().getValue("trueText"))) {
        returnValue.push(editor.properties().getValue("trueText"));
      }
    });
    return returnValue;
  };

  return ColumnListFE;
});
