/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/AnalyticOptionalValueFE
 */
define(['baja!', 'jquery', 'Promise', 'bajaux/Widget', 'dialogs', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/FrozenEnumEditor', 'nmodule/webEditors/rc/fe/fe', 'hbs!nmodule/analytics/rc/chart/templates/fe/analyticOptionalValue', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/BooleanEditor', 'lex!analytics'], function (baja, $, Promise, Widget, dialogs, events, FrozenEnumEditor, fe, analyticOptionalValue, BaseEditor, BooleanEditor, lexicon) {

  'use strict';

  var lex = lexicon[0];

  /**
   * A field editor for selecting tags from the station.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/analytics/rc/chart/fe/AnalyticOptionalValueFE
   */
  var AnalyticOptionalValueFE = function AnalyticOptionalValueFE() {
    BaseEditor.apply(this, arguments);
  };
  // Inheriting AnalyticDataEditorFE from BaseEditor
  AnalyticOptionalValueFE.prototype = Object.create(BaseEditor.prototype);
  // Setting the constructor
  AnalyticOptionalValueFE.prototype.constructor = AnalyticOptionalValueFE;

  /**
   * Creates a text box with a Data selection picker.
   * The data selection picker has a list box that shows all the available
   * tags for the selected node or all tags in the station.
   *
   * It uses NiagaraRpc to retrieve data from station.
   * @param {jQuery} dom
   */
  AnalyticOptionalValueFE.prototype.doInitialize = function (dom) {
    var that = this;
    dom.html(analyticOptionalValue({
      label: that.getLabel()
    }));
    // Units
    var feTextElement = that.$getDataElement(),
        feCheckboxElement = that.$getCheckboxElement();
    var isChecked = that.isSelected();
    feCheckboxElement.prop('checked', isChecked);
    feCheckboxElement.on('change', function () {
      that.jq().trigger(events.MODIFY_EVENT);
    });
    feTextElement.on('click', function (obj) {
      isChecked = that.isSelected();
      if (that.$getCheckboxElement().val()) {
        dialogs.showOkCancel({
          title: that.getLabel(),
          content: function content(dlg, jq) {
            jq.html("<div class='feDiv'></div>");
            return fe.buildFor({
              dom: $(".feDiv", jq),
              type: that.getFEType(),
              value: that.value().value
            }).then(function (propertyEditor) {
              return that.handleDataPropertyFEChanged(propertyEditor);
            });
          }
        }).ok(function (obj) {
          that.jq().trigger(events.MODIFY_EVENT);
        }).cancel(function (obj) {});
      }
    });
    return BaseEditor.prototype.doInitialize.apply(that, arguments);
  };
  /**
   * Handle the property changed event
   */
  AnalyticOptionalValueFE.prototype.handleDataPropertyFEChanged = function (propertyEditor) {
    // Time to register events.
    var that = this;
    propertyEditor.jq().on(events.MODIFY_EVENT, function () {
      var value = propertyEditor.doRead();
      that.$getDataElement().val(that.getDataValue(value));
      that.$getDataElement().attr("tag", that.getDataTag(value));
    });
    return Promise.resolve();
  };
  /**
   * Register the events for selection of data tag
   */
  AnalyticOptionalValueFE.prototype.registerEvents = function (jq, dom) {};
  /**
   * Loads a `baja.String` data value into the input element. I
   * @param {baja.String} value
   * @returns {Promise} promise to be resolved if the value is loaded,
   * or rejected if the `Data Value` could not be encoded to string
   */
  AnalyticOptionalValueFE.prototype.doLoad = function (value) {
    var that = this;
    this.$getDataElement().val(this.getDataValue(value.value));
    this.$getDataElement().attr("tag", this.getDataTag(value.value));
    that.$getCheckboxElement().val(value.isSelected);
    fe.buildFor({
      dom: $(".fe-checkbox", that.jq()),
      type: BooleanEditor,
      value: that.value().isSelected,
      properties: { trueText: " ", falseText: " " }
    }).then(function (propertyEditor) {
      // Time to register events.
      return propertyEditor.jq().on(events.MODIFY_EVENT, function () {
        var value = propertyEditor.doRead();
        that.$getCheckboxElement().val(value);
        return BaseEditor.prototype.doInitialize.apply(that, arguments);
      });
    });
  };
  /**
   * Get the value of data from type
   * @returns {*|jQuery|HTMLElement}
   */
  AnalyticOptionalValueFE.prototype.getDataValue = function (value) {
    return value.toString();
  };

  /**
   * Get the value of data from type
   * @returns {*|jQuery|HTMLElement}
   */
  AnalyticOptionalValueFE.prototype.getDataTag = function (value) {
    return value.getTag();
  };

  /**
   * Loads a `baja.String` data value into the input element. I
   * @param {baja.String} value
   * @returns {Promise} promise to be resolved if the value is loaded,
   * or rejected if the `Data Value` could not be encoded to string
   */
  AnalyticOptionalValueFE.prototype.$getDataElement = function () {
    return $('.fe-text', this.jq());
  };
  /**
   * Get the checkbox element
   * @returns {*|jQuery|HTMLElement}
   */
  AnalyticOptionalValueFE.prototype.$getCheckboxElement = function () {
    return $(".fe-checkbox", this.jq());
  };

  AnalyticOptionalValueFE.prototype.getFEType = function () {
    return FrozenEnumEditor;
  };

  AnalyticOptionalValueFE.prototype.getLabel = function () {
    var props = this.properties();
    return props.getValue("label") || lex.get('interval');
  };

  AnalyticOptionalValueFE.prototype.isSelected = function () {
    return $(".fe-checkbox", this.jq()).is(":checked");
  };

  /**
   * Reads the data value from the date input element and constructs a
   * `Data` from it.
   * @returns {String} the read `Data` value
   */
  AnalyticOptionalValueFE.prototype.doRead = function () {
    var val1 = this.$getDataElement().attr("tag");
    var isSelected = this.$getCheckboxElement().val();
    return {
      value: val1,
      isSelected: isSelected
    };
  };

  /**
   * Enables or disables the data input element.
   * @param {Boolean} enabled
   */
  AnalyticOptionalValueFE.prototype.doEnabled = function (enabled) {
    this.$getDataElement().prop('disabled', !enabled || this.isReadonly());
  };

  /**
   * Enables or disables the data input element.
   * @param {Boolean} readonly
   */
  AnalyticOptionalValueFE.prototype.doReadonly = function (readonly) {
    this.$getDataElement().prop('disabled', readonly || !this.isEnabled());
  };

  return AnalyticOptionalValueFE;
});
