/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * SpectrumChart.js
 * This javascript creates a SpectrumChart/HeatMap using d3 javascript.
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'underscore', 'd3', 'moment', 'nmodule/analytics/rc/util/analyticsUtil', 'nmodule/analytics/rc/chart/equipop/EquipmentOperationChart', 'nmodule/analytics/rc/chart/types/AnalyticD3LineChart', 'nmodule/analytics/rc/chart/types/AnalyticD3StackedBarChart', 'nmodule/analytics/rc/chart/equipop/AnalyticsTabConfigEqOpModel', 'nmodule/analytics/rc/chart/fe/EqOpConfigurationSettingsFE', 'lex!analytics', 'baja!analytics:AnalyticsTabConfigEqOpModel', 'css!nmodule/analytics/rc/chart/equipop/equipOperationChart'], function (baja, Widget, subscriberMixIn, Promise, $, _, d3, moment, analyticsUtil, EquipmentOperationChart, AnalyticD3LineChart, AnalyticD3StackedBarChart, AnalyticsTabConfigEqOpModel, EqOpConfigurationSettingsFE, lexicon) {

  "use strict";

  var lex = lexicon[0];
  var EqOpAggregateChart = function EqOpAggregateChart(params) {
    EquipmentOperationChart.call(this, $.extend({}, params));
    var that = this;
    that.columnKeys = ['grpName', 'y', 'yPercentile', 'metaData.interpolationStatus'];
    that.columnNames = [lex.get('report.headerText.groupName'), lex.get('report.headerText.runTimeHours'), lex.get('report.headerText.runTimePercentage'), lex.get("table.interpolationStatus.columnText")];
  };

  EqOpAggregateChart.prototype = Object.create(EquipmentOperationChart.prototype);
  EqOpAggregateChart.prototype.constructor = EqOpAggregateChart;

  EqOpAggregateChart.prototype.getColorCodedColKeys = function () {
    return ['grpName'];
  };

  EqOpAggregateChart.prototype.needsBreakOnOneIteration = function () {
    return false;
  };

  EqOpAggregateChart.prototype.getEquipmentRuntime = function (series, isIntervalTrend) {
    var trueDuration = 0,
        totalDuration = 0;
    var lastVal = false,
        lastTimestamp = -1,
        interval = -1;
    _.each(series.data, function (record, index) {
      // Get the timestamp and value of the current record.
      var curTs = record.x.getTime(),
          curVal = record.y;
      // If not the first record, go for the comparison
      if (lastTimestamp > 0) {
        // Count only those chunks of time when the last record was true. The current record state
        // is immaterial
        var durationLapsed = curTs - lastTimestamp;
        if (lastVal) {
          trueDuration += durationLapsed;
        }
        // Accumulate the total duration unconditionally
        totalDuration += durationLapsed;
        if (isIntervalTrend && interval === -1) {
          interval = durationLapsed;
        }
      }
      //Preserve the last timestamp and last value
      lastTimestamp = curTs;
      lastVal = curVal;
    });
    // Since interval trend is forward timestamped, we need to accumulate the last interval.
    // If not it may lead to wrong calculation.
    if (isIntervalTrend && interval !== -1) {
      var durationToAdd = interval,
          currentTime = baja.AbsTime.now().getMillis();
      if (lastTimestamp + interval > currentTime) {
        durationToAdd = currentTime - lastTimestamp;
      }
      if (lastVal) {
        trueDuration += durationToAdd;
      }
      totalDuration += durationToAdd;
    }
    return { onMillis: trueDuration, totalMillis: totalDuration };
  };

  /**
   *
   * @param chartSettingsCollection
   */
  EqOpAggregateChart.prototype.processData = function (chartSettingsCollection) {
    EquipmentOperationChart.prototype.processData.apply(this, arguments);
    var that = this;
    that.series = _.map(that.series, function (eachSeries, index) {
      var isIntervalTrend = chartSettingsCollection[index].getInterval() !== "none";
      var onOffMillis = that.getEquipmentRuntime(eachSeries, isIntervalTrend),
          onMillis = baja.RelTime.make(onOffMillis.onMillis),
          finalTrendFlags = 0;
      _.each(eachSeries.data, function (inData, index) {
        var dIntpStatus = inData.trendFlags;
        finalTrendFlags = finalTrendFlags | dIntpStatus;
      });
      eachSeries[that.getTableDataStructure()] = [{
        grpName: eachSeries.name,
        y: analyticsUtil.formatMillisForRuntime(onMillis),
        yPercentile: onOffMillis.totalMillis === 0 ? 0 : onMillis / onOffMillis.totalMillis * 100,
        metaData: { interpolationStatus: analyticsUtil.decodeTrendFlag(finalTrendFlags) }
      }];
      return eachSeries;
    });
  };

  EqOpAggregateChart.prototype.getTableDataStructure = function () {
    return 'aggregatedData';
  };

  /**
   *
   * @returns {[string,string]}
   */
  EqOpAggregateChart.prototype.getColumnNames = function () {
    return this.columnNames;
  };

  /**
   *
   * @returns {[string,string]}
   */
  EqOpAggregateChart.prototype.getColumnKeys = function () {
    return this.columnKeys;
  };

  EqOpAggregateChart.prototype.getName = function () {
    return "EqOpAggregateChart";
  };

  return EqOpAggregateChart;
});
