/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author : Komaravolu, sai
 * @file Model for Tab Configuration Data for analytics views
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/chart/base/AnalyticsTabConfigBaseModel
 */
define(['baja!'], function (baja) {

  "use strict";
  /**
   * Represents a model for tab configurations.
   * @class
   * @alias module:nmodule/analytics/rc/chart/base/AnalyticsTabConfigBaseModel
   */

  var AnalyticsTabConfigBaseModel = function AnalyticsTabConfigBaseModel(input) {
    var that = this;
    that.$fontSize = input.fontSize || 10;
    that.$background = input.background || "";
    that.$xAxisColor = input.xAxisColor || "";
    that.$yAxisColor = input.yAxisColor || "";
    that.$legendOnOff = input.legendOnOff || true;
    that.$commandBarOnOff = input.commandBarOnOff || true;
    that.$showTextWithoutClipOnOff = input.showTextWithoutClipOnOff || true;
    that.$isModified = input.isModified || false;
  };

  AnalyticsTabConfigBaseModel.prototype = Object.create(Object.prototype);

  AnalyticsTabConfigBaseModel.prototype.constructor = AnalyticsTabConfigBaseModel;

  AnalyticsTabConfigBaseModel.prototype.getFontSize = function () {
    return this.$fontSize;
  };
  AnalyticsTabConfigBaseModel.prototype.setFontSize = function (fontSize) {
    this.$fontSize = fontSize;
  };

  AnalyticsTabConfigBaseModel.prototype.getBackground = function () {
    return this.$background;
  };
  AnalyticsTabConfigBaseModel.prototype.setBackground = function (background) {
    this.$background = background;
  };

  AnalyticsTabConfigBaseModel.prototype.getXAxisColor = function () {
    return this.$xAxisColor;
  };
  AnalyticsTabConfigBaseModel.prototype.setXAxisColor = function (xAxisColor) {
    this.$xAxisColor = xAxisColor;
  };

  AnalyticsTabConfigBaseModel.prototype.getYAxisColor = function () {
    return this.$yAxisColor;
  };
  AnalyticsTabConfigBaseModel.prototype.setYAxisColor = function (yAxisColor) {
    this.$yAxisColor = yAxisColor;
  };

  AnalyticsTabConfigBaseModel.prototype.getLegendOnOff = function () {
    return this.$legendOnOff;
  };
  AnalyticsTabConfigBaseModel.prototype.setLegendOnOff = function (legendOnOff) {
    this.$legendOnOff = legendOnOff;
  };

  AnalyticsTabConfigBaseModel.prototype.isModified = function () {
    return this.$isModified;
  };
  AnalyticsTabConfigBaseModel.prototype.setModified = function (isModified) {
    this.$isModified = isModified;
  };

  /**
   * Sets the defaults back.
   */
  AnalyticsTabConfigBaseModel.prototype.setDefaults = function () {};

  /**
   * Re build the model with the incoming model.
   * Children models should implement the rebuild method.
   */
  AnalyticsTabConfigBaseModel.prototype.$rebuild = function (inModel) {
    this.setFontSize(inModel.$fontSize);
    this.rebuild(inModel);
  };

  /**
   * Children should implement the method to rebuild the tab configuration model.
   * @param inModel
   */
  AnalyticsTabConfigBaseModel.prototype.rebuild = function (inModel) {
    return {};
  };

  /**
   * Equals method will compare the input model with the current model,
   * returns true if it matches, else calls the children implementation of equals.
   * @param inModel
   * @returns {boolean}
   */
  AnalyticsTabConfigBaseModel.prototype.$equals = function (inModel) {
    var that = this;
    if (inModel.getFontSize() === this.getFontSize() && that.equals(inModel)) {
      return true;
    }
    return false;
  };

  AnalyticsTabConfigBaseModel.prototype.toString = function () {
    var that = this;
    return {
      fontSize: that.$fontSize,
      background: that.$background,
      xAxisColor: that.$xAxisColor,
      yAxisColor: that.$yAxisColor,
      legendOnOff: that.$legendOnOff,
      commandBarOnOff: that.$commandBarOnOff,
      showTextWithoutClipOnOff: that.$showTextWithoutClipOnOff,
      isModified: that.$isModified
    };
  };

  /**
   * Open for implementation by children.
   * By default it returns false.
   * @param inModel
   * @returns {boolean}
   */
  AnalyticsTabConfigBaseModel.prototype.equals = function (inModel) {
    return true;
  };

  return AnalyticsTabConfigBaseModel;
});
