/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 *@file Model for Baseline Chart Data for analytics views
 * @author : Upender Paravastu
 *
 */
define(['baja!', 'nmodule/analytics/rc/util/analyticsUtil', 'nmodule/analytics/rc/chart/base/AnalyticsMultiNodeDataModel', 'underscore', 'baja!analytics:BaselineTimeRangeEnum'], function (baja, analyticsUtil, AnalyticsMultiNodeDataModel, _, types) {

    "use strict";
    /**
     * Represents a model for chart settings and corresponding series data
     * @param chartSettings
     * @constructor
     */

    var AnalyticMultiNodeBaselineModel = function AnalyticMultiNodeBaselineModel(chartSettings) {
        AnalyticsMultiNodeDataModel.apply(this, arguments);
    };

    AnalyticMultiNodeBaselineModel.prototype = Object.create(AnalyticsMultiNodeDataModel.prototype);

    AnalyticMultiNodeBaselineModel.prototype.constructor = AnalyticMultiNodeBaselineModel;

    /**
     * Re - build the ORD from scratch using the parameters in 'this' instance.
     */
    AnalyticMultiNodeBaselineModel.prototype.rebuildOrd = function (ordScheme) {
        this.setNodeModel(analyticsUtil.getMultiNodeOrd(this, ordScheme));
    };

    AnalyticMultiNodeBaselineModel.prototype.getBaselineTimeRange = function () {
        return this.$baselineTR;
    };

    AnalyticMultiNodeBaselineModel.prototype.setBaselineTimeRange = function (baselineTR) {
        this.$baselineTR = baja.$("analytics:BaselineTimeRangeEnum").make(baselineTR);
    };

    return AnalyticMultiNodeBaselineModel;
});
