/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * SpectrumChart.js
 * This javascript creates a SpectrumChart/HeatMap using d3 javascript.
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'underscore', 'd3', 'moment', 'nmodule/analytics/rc/chart/base/AnalyticC3BaseChart', 'nmodule/analytics/rc/chart/equipop/AnalyticsTabConfigEqOpModel', 'nmodule/analytics/rc/chart/fe/EqOpConfigurationSettingsFE', 'nmodule/analytics/rc/util/analyticsUtil', 'nmodule/webEditors/rc/wb/util/ICollectionSupport', 'lex!analytics', 'baja!analytics:AnalyticsTabConfigEqOpModel', 'baja!analytics:C3ChartTypeParams', 'css!nmodule/analytics/ext/c3/c3'], function (baja, Widget, subscriberMixIn, Promise, $, _, d3, moment, AnalyticC3BaseChart, AnalyticsTabConfigEqOpModel, EqOpConfigurationSettingsFE, analyticsUtil, ICollectionSupport, lexicon) {

  "use strict";

  // var lex = lexicon[0];
  /**
   *
   * @class
   * @alias module:nmodule/analytics/rc/chart/analyticwebchart/AnalyticWebChart
   * @extends module:nmodule/analytics/rc/chart/base/AnalyticC3BaseChart
   * @mixes module:nmodule/webEditors/rc/wb/util/ICollectionSupport
   * @param {Object} [params]
   */

  var AnalyticWebChart = function AnalyticWebChart(params) {
    AnalyticC3BaseChart.call(this, $.extend({}, params));
    ICollectionSupport(this);
  };

  AnalyticWebChart.prototype = Object.create(AnalyticC3BaseChart.prototype);
  AnalyticWebChart.prototype.constructor = AnalyticWebChart;

  /**
   * This method should be overridden by subclasses to return respective chart types.
   * The default implementation retruns "none".
   * @returns {string}
   */
  AnalyticWebChart.prototype.getSupportedExportTypes = function () {
    return ["awchart", "csv"];
  };

  /**
   *
   * @param chartSettingsCollection
   */
  AnalyticWebChart.prototype.processData = function (chartSettingsCollection) {
    var that = this,
        seriesList = [];
    return AnalyticC3BaseChart.prototype.processData.apply(that, arguments).then(function (chartColl) {
      chartSettingsCollection = chartColl;
      for (var i = 0; i < chartSettingsCollection.length; i++) {
        var model = chartSettingsCollection[i];
        var series = {
          name: model.getSeriesName(),
          chartType: model.getChartType(),
          showOnY2: model.getShowOnY2(),
          data: model.getAnalyticTrendArray(),
          color: model.getBrush(),
          unit: model.getUnit().getSymbol(),
          ord: model.getOrd()
        };
        seriesList.push(series);
      }
      that.series = seriesList; // each series now has only one record
      return Promise.resolve(analyticsUtil.getRenderableC3Data(that, that.series));
    });
  };

  AnalyticWebChart.prototype.getMetaData = function (data) {
    return { interpolationStatus: data.interpolationStatus };
  };

  /**
   *
   * @returns {string[]}
   */
  AnalyticWebChart.prototype.getColorCodedColKeys = function () {
    return ['grpName'];
  };

  /**
   *
   * @returns {boolean}
   */
  AnalyticWebChart.prototype.needsBreakOnOneIteration = function () {
    return false;
  };

  /**
   *
   * @returns {string}
   */
  AnalyticWebChart.prototype.getTableDataStructure = function () {
    return 'aggregatedData';
  };

  /**
   *
   * @returns {[string,string]}
   */
  AnalyticWebChart.prototype.getColumnNames = function () {
    return this.columnNames;
  };

  /**
   *
   * @returns {[string,string]}
   */
  AnalyticWebChart.prototype.getColumnKeys = function () {
    return this.columnKeys;
  };

  /**
   * Open for the children to override.
   * Should return the Y Axis label.
   * @param text
   */
  AnalyticWebChart.prototype.getY2AxisType = function () {};

  /**
   *
   * @param data
   * @param timeRange
   * @returns {*}
   */
  AnalyticWebChart.prototype.buildModel = function (data, timeRange) {
    var model = AnalyticC3BaseChart.prototype.buildModel.apply(this, arguments);
    model.setShowOnY2(data.getShowOnY2());
    return model;
  };

  AnalyticWebChart.prototype.getName = function () {
    return "AnalyticWebChart";
  };

  /**
   *
   * @returns {string[]|(string)[]|module:http2.Settings|{data, dataFilter, timeRange, interval, unit, rollup, aggregation, dow, seriesNameBFormat, hisTotEnabled}|*}
   */
  AnalyticWebChart.prototype.getDefaultSettings = function () {
    var defObj = AnalyticC3BaseChart.prototype.getDefaultSettings.apply(this, arguments);
    defObj.chartType = "line";
    return defObj;
  };

  return AnalyticWebChart;
});
