/*global console */
/**
 * @private
 * @module nmodule/micros/rc/SyncSummaryCommand
 */
define([
  'baja!',
  'baja!baja:JobState',
  'lex!baja',
  'nmodule/micros/rc/MicrosUtils',
  'bajaux/commands/Command',
  'nmodule/webEditors/rc/wb/job/jobSupport',
  'dialogs',
  'Promise',
  'underscore',
  'jquery',
  'nmodule/webEditors/rc/fe/fe',
  'nmodule/webEditors/rc/wb/table/Table',
  'hbs!nmodule/micros/rc/templates/SyncSummary'
    ], function (
   baja,
   types,
   lexs,
   MicrosUtils,
   Command,
   jobSupport,
   dialogs,
   Promise,
   _,
   $,
   fe,
   Table,
   SyncSummaryTpl
    ) {

  'use strict';

  var JOB_STATE_TYPE = baja.lt(MicrosUtils.typeSpec.JOB_STATE),
      DB_SUMMARY_LABEL = 'pmc.DbSyncSummary.label',
      DIALOG_TITLE = 'ds.title',
      SUMMARY_TAB_TITLE = 'ds.tab.summary',
      DETAIL_TAB_TITLE = 'ds.tab.detail',
      NO_NETWORK = 'pmc.noNetwork',
      NO_JOB_RESUTLS = 'ds.popup.noResults',
      SUMMARY_HEADER_PROPERTY = 'header.property',
      SUMMARY_HEADER_VALUE = 'header.value',
      SYNC_SUMMARY_COMMAND_ERROR = 'pmc.DbSyncSummary.error';


  var SyncSummaryCommand = function SyncSummaryCommand(manager) {
    var that = this;

    // borrowed from jobBar.js
    SyncSummaryCommand.configureDoubleClick = function(elem) {
    //function configureDoubleClick (elem) {
      elem.on('dblclick', 'tr', function (e) {
        var tr = $(e.target),
          table = tr.closest('.detailContentTable').data('widget'),
          item = _.head(table.getSubject(tr));

        jobSupport.showItemDetailsDialog(item);
      });
    };


    // helpler function for configureTabNavigation
    var makeEverythingInactive = function(element) {
      // make all tabs inactive
      element.find('.tabTitle').removeClass('activeTab').addClass('inactiveTab');

      // make all content inactive
      element.find('div.content').removeClass('activeTab').addClass('inactiveTab');
    };

    // set up the handlers for shifting between the tabs on the dialog
    SyncSummaryCommand.configureTabNavigation = function (elem) {
    //var configureTabNavigation = function (elem) {
      elem.on('click', 'div.tabTitle.summary', function (e) {
        makeEverythingInactive(elem);

        // make the detail tab active
        elem.find('div.tabTitle.summary').removeClass('inactiveTab').addClass('activeTab');

        // make the detail content active
        elem.find('div.content.summaryContent').removeClass('inactiveTab').addClass('activeTab');
      });

      elem.on('click', 'div.tabTitle.detail', function (e) {
        makeEverythingInactive(elem);

        // make the detail tab active
        elem.find('div.tabTitle.detail').removeClass('inactiveTab').addClass('activeTab');

        // make the detail content active
        elem.find('div.content.detailContent').removeClass('inactiveTab').addClass('activeTab');
      });
    };


    Command.call(that, {
      module: 'micros',
      lex: 'pmc.DbSyncSummary',
      // should mean that pmc.DbSyncSummary.icon gets used as the icon, and
      // pmc.DbSyncSummary.label is used as the button label.

      // however pmc.DbSyncCmd.label doesn't exist currently, so ...
      displayName: MicrosUtils.microsLex(DB_SUMMARY_LABEL),
      enabled:     true,

      func: function () {
        SyncSummaryCommand.doSyncSummary(manager);
      }
    });
  };

  SyncSummaryCommand.prototype = Object.create(Command.prototype);
  SyncSummaryCommand.prototype.constructor = SyncSummaryCommand;

  SyncSummaryCommand.constructDatabaseSyncJobOrd = function(base, child) {
    return baja.Ord.make({
      base:   base,
      child:  child
    });
  };

  SyncSummaryCommand.doSyncSummary = function(manager) {
    // expecting manager to be MicrosPointManager
    var network = manager.getNetwork();

    if (!network) {
      console.error('SyncSummaryCommand: ' + MicrosUtils.microsLex(NO_NETWORK));
      dialogs.showOk(MicrosUtils.microsLex(NO_NETWORK))
      .ok(function(){return true;});
      return;
    }

    try {
      // lease the Micros Network to get the latest DatabaseSyncJobOrd value
      baja.Ord.make(network.getNavOrd()).get({lease: true})
      .then(function(leasedNetwork){
        var databaseSyncJobOrd = network.getDatabaseSyncJobOrd();

        if (!databaseSyncJobOrd || databaseSyncJobOrd === baja.Ord.DEFAULT) {
          console.log('SyncSummaryCommand: ' + MicrosUtils.microsLex(NO_JOB_RESUTLS));
          dialogs.showOk(MicrosUtils.microsLex(NO_JOB_RESUTLS))
          .ok(function(){return true;});
          return;
        }

        SyncSummaryCommand.constructDatabaseSyncJobOrd(network.getNavOrd(), databaseSyncJobOrd)
        .get({lease: true})
        .then(function(job) {
          //console.log('SyncSummaryCommand, job: ' + job);

          jobSupport.readLogItems(job)
          .then(function(jobLog) {

            var i, obj,
                summaryPropertyList = [],
                listSize = job.$map.getSize();

            for (i = 0; i < listSize; i++) {
              obj = job.$map.getFromIndex(i);

              if (obj instanceof baja.Property) {
                summaryPropertyList.push( SyncSummaryCommand.getSummaryPropertyValues(obj) );
              }
            }

            // Create and show the dialog containing the table of log entries.
            // (borrowed from jobBar.js)
            function showDialog (params) {
              return new Promise(function (resolve, reject) {
                dialogs.showOk({
                  title: MicrosUtils.microsLex(DIALOG_TITLE),
                  content: function (dlg, content) {
                    return fe.buildFor(params)
                    .then(function (ed) {
                      content
                        .prepend( SyncSummaryCommand.getDialogContent(summaryPropertyList)  )
                        .find('div.content.detailContent').prepend(ed.jq());

                      SyncSummaryCommand.configureDoubleClick(params.dom);
                      SyncSummaryCommand.configureTabNavigation(content);
                      dlg.ok(function () {
                        ed.jq().off();
                        return ed.destroy();
                      });
                    })
                    .catch(reject);
                  }
                });
              });
            }

            var rows = _.map(jobLog, jobSupport.makeLogTableRow),
                model = jobSupport.makeLogModel(rows, {});

            return showDialog({
              dom: $('<table class="detailContentTable"/>'),
              value: model,
              type: Table
            });
          });
        });
      });
    } catch (err) {
      console.error( MicrosUtils.microsLex(SYNC_SUMMARY_COMMAND_ERROR, '', [err]) );
    }

  };

  SyncSummaryCommand.getSummaryPropertyValues = function(property) {

    var displayName = property.$displayName,
        objValue = property.$getDisplay(),
        styleClass = '';

    // special case for Job State
    if (property.getType() === JOB_STATE_TYPE) {
      var jobStateEnum = baja.Enum.getEnumFromIEnum(property.$getValue());
      objValue = jobStateEnum.getDisplayTag();

      if (jobStateEnum === MicrosUtils.JobState.SUCCESS) {
        styleClass = 'JobState Success';
      }
      else if (jobStateEnum === MicrosUtils.JobState.FAILED) {
        styleClass = 'JobState Failed';
      }
    }

    var returnValue = {
      displayName:  displayName,
      objValue:     objValue,
      styleClass:   styleClass
    };
    return returnValue;
  };

  SyncSummaryCommand.getDialogContent = function(summaryPropertyList) {
    return SyncSummaryTpl({
      detailTabTitle: MicrosUtils.microsLex(DETAIL_TAB_TITLE),
      summaryTabTitle: MicrosUtils.microsLex(SUMMARY_TAB_TITLE),
      summaryItems: summaryPropertyList,
      propertyColHeader: MicrosUtils.microsLex(SUMMARY_HEADER_PROPERTY),
      valueColHeader: MicrosUtils.microsLex(SUMMARY_HEADER_VALUE)
    });
  };


  return SyncSummaryCommand;
});
