function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */
define(['baja!', 'baja!baja:SecurityItemStatus', 'lex!', 'lex!nss', 'jquery', 'Promise', 'underscore', 'nmodule/js/rc/csrf/csrfUtil', 'nmodule/nss/rc/model/Entity', 'nmodule/nss/rc/model/Item', 'nmodule/nss/rc/model/ItemCollection', 'nmodule/nss/rc/model/Severity', 'nmodule/nss/rc/model/SourceCollection'], function (baja, types, lex, lexs, $, Promise, _, csrfUtil, Entity, Item, ItemCollection, Severity, SourceCollection) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      nssLex = _lexs[0];

  var CSRF_TOKEN_HEADER_KEY = csrfUtil.CSRF_TOKEN_HEADER_KEY,
      getCsrfToken = csrfUtil.getCsrfToken;
  /**
   * API Status: **Private**
   * @exports nmodule/nss/rc/rpc/rpc
   */

  var exports = {};
  /**
   * Defines how RPC calls are made for a particular dashboard view.
   * @interface IDashboardService
   * @memberOf module:nmodule/nss/rc/rpc/rpc
   */

  /**
   * Get the SourceCollection for the entire dashboard, including all sources.
   *
   * @function getSourceCollection
   * @memberOf module:nmodule/nss/rc/rpc/rpc.IDashboardService#
   * @param {string} ord
   * @returns {Promise.<module:nmodule/nss/rc/model/SourceCollection>}
   */

  /**
   * Get an ItemCollection for one particular source in the currently loaded
   * SourceCollection.
   *
   * @function getItemCollection
   * @memberOf module:nmodule/nss/rc/rpc/rpc.IDashboardService#
   * @param {string} ord the ORD of the component to provide dashboard info
   * @param {string} name the name of the individual source of dashboard info
   * (in case of system view, this will be the station name)
   * @param {Date} [timestamp] requesting data only if there are updates after this time.
   * @returns {Promise.<module:nmodule/nss/rc/model/ItemCollection>}
   */

  /**
   * Request a refresh for a particular source in the currently loaded
   * SourceCollection. This only sends a request for the station to start the
   * refresh job; it will not actually resolve any new data. Wait a reasonable
   * period and then call getItemCollection again.
   *
   * @function requestRefresh
   * @memberOf module:nmodule/nss/rc/rpc/rpc.IDashboardService#
   * @param {string} ord the ORD of the component to provide dashboard info
   * @param {string} name the name of the individual source of dashboard info
   * (in case of system view, this will be the station name)
   * @returns {Promise}
   */

  /**
   * @function onItemCollectionUpdated
   * @memberOf module:nmodule/nss/rc/rpc/rpc.IDashboardService#
   * @param {rpc.IDashboardService~ItemCollectionUpdatedCallback} cb
   */

  /**
   * @callback rpc.IDashboardService~ItemCollectionUpdatedCallback
   * @param {module:nmodule/nss/rc/model/ItemCollection} itemCollection
   * the item collection that has been updated.
   */

  /**
   * Retrieve data indicating whether the station/system views are enabled on
   * the given ORD.
   * @param {string|baja.Ord} providerOrd the ORD of the current provider of dashboard data in the station
   * @returns {Promise<Object>}
   */

  exports.getDashboardStatus = function (providerOrd) {
    return exports.$getDashboardStatus(providerOrd);
  };
  /**
   * Retrieve data for the station security dashboard.
   *
   * @param {string|baja.Ord} providerOrd the ORD of the current provider of dashboard data in the station
   * @returns {Promise.<module:nmodule/nss/rc/model/SourceCollection>}
   */


  exports.getStationData = function (providerOrd) {
    return exports.$getStationJson(providerOrd).then(function (json) {
      return exports.$stationJsonToSourceCollection(json, {
        providerOrd: providerOrd
      });
    });
  };
  /**
   * Retrieve data for the system security dashboard.
   *
   * @param {string|baja.Ord} providerOrd the ORD of the current provider of dashboard data in the supervisor
   * @returns {Promise.<module:nmodule/nss/rc/model/SourceCollection>}
   */


  exports.getSystemDataAll = function (providerOrd) {
    return exports.$getSystemJson(providerOrd).then(function (json) {
      return exports.$systemJsonToSourceCollection(json, {
        providerOrd: providerOrd
      });
    });
  };
  /**
   * Get the refreshed set of items from one source in a station. Not used in
   * practice; at a station level, the entire station will be refreshed at once.
   * @param {string} srcEntityOrd - Ord for the source entity
   * @return {Promise.<module:nmodule/nss/rc/model/ItemCollection>} Promise wrapped with the refreshed ItemCollection
   */


  exports.getStationItemCollection = function (srcEntityOrd) {
    return exports.getStationData(baja.Ord.make('station:|service:nss:SecurityService')) //TODO: Once backend is running, change this.
    .then(function (sourceCollection) {
      return sourceCollection.getItemCollection(srcEntityOrd);
    });
  };
  /**
   * Retrieve data for one station in a system dashboard rollup.
   *
   * @param {string|baja.Ord} ord the ORD of the current provider of dashboard data in the supervisor
   * @param {string} stationName the name of the station being retrieved
   * @param {Date} [lastDataTimestamp] the timestamp of the last existing data we have for this station
   * @returns {Promise.<module:nmodule/nss/rc/model/ItemCollection>}
   */


  exports.getSystemDataSingle = function (ord, stationName, lastDataTimestamp) {
    return exports.$getSystemStationJson(ord, stationName, lastDataTimestamp).then(function (json) {
      return exports.$systemStationJsonToItemCollection(json, {
        providerOrd: ord,
        lastDataTimestamp: lastDataTimestamp
      });
    });
  };
  /**
   * Trigger a request for the station to start rebuilding security data for a
   * particular station.
   *
   * @param {string|baja.Ord} ord the ORD of the current provider of dashboard data in the supervisor
   * @param {string} stationName
   * @returns {Promise}
   */


  exports.refreshSystemSingle = function (ord, stationName) {
    return exports.$refreshSystemStation(ord, stationName);
  };
  /**
   * Get JSON indicating whether the system and station views are enabled.
   * @returns {Promise.<object>}
   */


  exports.$getDashboardStatus = function (ord) {
    return doGet("/nss/dashboardStatus?ord=".concat(ord));
  };
  /**
   * Get complete JSON for the station view.
   *
   * @private
   * @param {string|baja.Ord} providerOrd
   * @returns {Promise.<object>}
   */


  exports.$getStationJson = function (providerOrd) {
    return doGet("/nss/station/data?ord=".concat(providerOrd));
  };
  /**
   * Get complete JSON for the system view.
   *
   * @private
   * @param {string|baja.Ord} providerOrd
   * @returns {Promise.<object>}
   */


  exports.$getSystemJson = function (providerOrd) {
    return doGet("/nss/system/data?ord=".concat(providerOrd));
  };
  /**
   * Get JSON for one station in the system view.
   *
   * @private
   * @param {string|baja.Ord} ord the ORD of the current provider of dashboard data in the supervisor
   * @param {string} stationName the name of the station being retrieved
   * @param {Date} [lastDataTimestamp] the timestamp of the last existing data we have for this station
   * @returns {Promise.<object>}
   */


  exports.$getSystemStationJson = function (ord, stationName, lastDataTimestamp) {
    var url = "/nss/system/data/station/".concat(stationName, "?ord=").concat(ord);

    if (lastDataTimestamp) {
      url = "".concat(url, "&lastDataTimestamp=").concat(lastDataTimestamp.toISOString());
    }

    return doGet(url);
  };

  function doGet(url) {
    return Promise.resolve($.get(url))["catch"](function (xhr) {
      throw new Error(xhr.statusText);
    });
  }
  /**
   * Trigger a refresh request for one station in the system view.
   *
   * @private
   * @param {string|baja.Ord} ord
   * @param {string} stationName
   * @returns {Promise}
   */


  exports.$refreshSystemStation = function (ord, stationName) {
    return Promise.resolve($.ajax("/nss/system/refresh/station/".concat(stationName, "?ord=").concat(ord), {
      method: 'POST',
      headers: _defineProperty({}, CSRF_TOKEN_HEADER_KEY, getCsrfToken())
    }));
  };
  /**
   * Convert the result of a `getStationData` servlet call into a
   * SourceCollection.
   *
   * @private
   * @param {object} json JSON object retrieved from servlet
   * @param {string} json.stationName Station Name that represents the SourceCollection
   * @param {object[]} json.sections Set of section objects that each derive an ItemCollection
   * @param {Date} json.timestamp Time of the data fetch
   * @param {object} params
   * @param {string|baja.Ord} params.providerOrd base Ord of the components to be resolved
   * @returns {Promise.<module:nmodule/nss/rc/model/SourceCollection>}
   * @see module://nssTest/rc/schema/v1/single-station.json
   */


  exports.$stationJsonToSourceCollection = function (json, params) {
    return stationJsonToSourceCollection(json, params);
  };
  /**
   * Convert the result of a `getSystemDataAll` servlet call into a
   * SourceCollection.
   *
   * @private
   * @param {object} json JSON object retrieved from the servlet
   * @param {object[]} json.stations Set of objects with data from each station
   * in the system
   * @param {object} [params]
   * @param {string} [params.providerOrd=''] the ORD of the security dashboard service; will be set on the source entity so future refresh
   * calls can be relativized
   * @returns {Promise.<module:nmodule/nss/rc/model/SourceCollection>}
   * @see module://nssTest/rc/schema/v1/system-rollup.json
   */


  exports.$systemJsonToSourceCollection = function (_ref) {
    var stations = _ref.stations;

    var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        _ref2$providerOrd = _ref2.providerOrd,
        providerOrd = _ref2$providerOrd === void 0 ? '' : _ref2$providerOrd;

    return Promise.all(stations.map(function (station) {
      var stationDashboardData = station.stationDashboardData,
          stationName = station.stationName,
          ord = station.ord,
          stationStatus = station.stationStatus;
      return stationJsonToSourceCollection(_.extend({}, stationDashboardData, {
        stationName: stationName,
        ord: ord
      }), {
        stationStatus: stationStatus
      }).then(function (sourceCollection) {
        var itemCollection = sourceCollectionToItemCollection(sourceCollection);
        itemCollection.data('status', getItemCollectionStatus(station));
        return itemCollection;
      });
    })).then(function (itemCollections) {
      return new SourceCollection({
        sourceEntity: new Entity({
          name: '',
          ord: providerOrd
        }),
        itemCollections: itemCollections
      });
    });
  };
  /**
   * Convert the result of a `getSystemDataSingle` servlet call into a
   * SourceCollection.
   *
   * @private
   * @param {object} json JSON object retrieved from the servlet for one station in a rollup
   * @param {object} params
   * @param {string} [params.ord] the ORD of the current provider of dashboard data in the supervisor
   * @param {Date} [params.lastDataTimestamp] the timestamp of the last existing data we have for this station
   * @returns {Promise.<module:nmodule/nss/rc/model/ItemCollection>}
   */


  exports.$systemStationJsonToItemCollection = function (_ref3) {
    var stations = _ref3.stations;

    var _ref4 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        lastDataTimestamp = _ref4.lastDataTimestamp;

    var station = stations[0];
    var stationName = station.stationName,
        stationDashboardData = station.stationDashboardData,
        stationStatus = station.stationStatus,
        ord = station.ord;
    return stationJsonToSourceCollection(_.extend({}, stationDashboardData, {
      stationName: stationName,
      ord: ord
    }), {
      stationStatus: stationStatus,
      lastDataTimestamp: lastDataTimestamp
    }).then(sourceCollectionToItemCollection).then(function (itemCollection) {
      itemCollection.data('status', getItemCollectionStatus(station));
      return itemCollection;
    });
  };
  /**
   * Consolidate all items in a SourceCollection into an ItemCollection.
   * @param {module:nmodule/nss/rc/model/SourceCollection} sourceCollection collection of all item sources in a station
   * @returns {module:nmodule/nss/rc/model/ItemCollection} a collection of all items in a station, to be shown in the system view
   */


  function sourceCollectionToItemCollection(sourceCollection) {
    return new ItemCollection({
      entity: sourceCollection.getSourceEntity(),
      items: getAllItemsInSourceCollection(sourceCollection),
      timestamp: sourceCollection.getTimestamp()
    });
  }
  /**
   * @param {module:nmodule/nss/rc/model/SourceCollection} sourceCollection
   * @returns {Array.<module:nmodule/nss/rc/model/Item>}
   */


  function getAllItemsInSourceCollection(sourceCollection) {
    var itemArrays = sourceCollection.getItemCollections().map(function (coll) {
      return coll.getItems();
    });
    return _.flatten(itemArrays);
  }
  /**
   * Given one entry in the `stations` array in the the system rollup JSON, what
   * is the status of the collection of items fetched from this station?
   *
   * @param {object} params
   * @param {string} params.stationStatus
   * @param {string} params.refreshStatus
   * @param {object} params.stationDashboardData
   * @returns {module:nmodule/nss/rc/model/ItemCollection.status}
   */


  function getItemCollectionStatus(_ref5) {
    var stationStatus = _ref5.stationStatus,
        refreshStatus = _ref5.refreshStatus,
        stationDashboardData = _ref5.stationDashboardData;
    var status = ItemCollection.status;

    if (stationStatus && stationStatus !== 'ok' || refreshStatus === 'failed') {
      return status.FAILED;
    }

    if (refreshStatus === 'inProgress') {
      return status.PENDING;
    }

    return stationDashboardData ? status.COMPLETE : status.UP_TO_DATE;
  }
  /**
   * Convert station JSON (either the result of a `getStationData` call, or
   * `stationDashboardData` from a `getSystemDataAll` or `getSystemDataSingle`
   * call) into a SourceCollection.
   *
   * @param {object} json the actual station JSON coming back from the server
   * @param {string} json.stationName
   * @param {Array.<object>} [json.sections=[]]
   * @param {string} [json.timestamp] the timestamp of the station data reported by the server
   * @param {string} [json.ord='']
   * @param {object} [params]
   * @param {string} [params.stationStatus='']
   * @param {Date} [params.lastDataTimestamp] the timestamp of the last existing data we have for this station
   * @returns {Promise.<module:nmodule/nss/rc/model/SourceCollection>}
   */


  function stationJsonToSourceCollection(json) {
    var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var stationName = json.stationName,
        _json$sections = json.sections,
        sections = _json$sections === void 0 ? [] : _json$sections,
        timestamp = json.timestamp,
        _json$ord = json.ord,
        ord = _json$ord === void 0 ? '' : _json$ord;
    var _params$stationStatus = params.stationStatus,
        stationStatus = _params$stationStatus === void 0 ? '' : _params$stationStatus,
        lastDataTimestamp = params.lastDataTimestamp;
    var date = new Date(timestamp || lastDataTimestamp || new Date());

    if (stationStatus === 'fault' || stationStatus === 'down') {
      sections = [makeUnreachableSectionJson(stationName)];
    }

    return Promise.all(sections.map(function (section) {
      return sectionToItemCollection(section, {
        timestamp: date
      });
    })).then(function (itemCollections) {
      return new SourceCollection({
        sourceEntity: new Entity({
          name: stationName,
          ord: ord
        }),
        itemCollections: itemCollections.sort(byMaxSeverity),
        timestamp: date
      });
    });
  }

  function makeUnreachableSectionJson(stationName) {
    return {
      sectionHeader: {
        lexiconKey: "nss:SecurityDashboardView.station.unreachable"
      },
      subsections: [{
        dashboardItems: [{
          description: {
            lexiconKey: 'nss:SecurityDashboardView.station.unreachable',
            arguments: [{
              value: stationName
            }]
          },
          status: "securityStatusAlert",
          summary: {
            lexiconKey: 'nss:SecurityDashboardView.station.unreachable',
            arguments: [{
              value: stationName
            }]
          }
        }]
      }]
    };
  }
  /**
   * Get a collection of the items in one section of station dashboard data.
   *
   * @param {object} json section JSON
   * @param {string} json.ord
   * @param {object} json.sectionHeader
   * @param {object} params
   * @param {Date} params.timestamp the generation timestamp to assign the item collection
   * @returns {Promise.<module:nmodule/nss/rc/model/ItemCollection>}
   */


  function sectionToItemCollection(json, params) {
    var _json$ord2 = json.ord,
        ord = _json$ord2 === void 0 ? '' : _json$ord2,
        sectionHeader = json.sectionHeader,
        subsections = json.subsections;
    var timestamp = params.timestamp;
    return objectToLex(sectionHeader).then(function (name) {
      var entity = new Entity({
        name: name,
        ord: ord
      });
      return Promise.all(subsections.map(function (subsection) {
        return subsectionToItems(subsection, entity);
      })).then(function (itemLists) {
        return new ItemCollection({
          entity: entity,
          items: _.flatten(itemLists),
          timestamp: timestamp
        });
      });
    });
  }
  /**
   * Get the items in a subsection of a section of station dashboard data.
   *
   * @param {object} subsection
   * @param {Array.<object>} subsection.dashboardItems
   * @param {module:nmodule/nss/rc/model/Entity} sourceEntity the source of these items
   * @returns {Promise.<Array.<module:nmodule/nss/rc/model/Item>>}
   */


  function subsectionToItems(_ref6, sourceEntity) {
    var dashboardItems = _ref6.dashboardItems;
    return Promise.all(dashboardItems.map(function (item) {
      return dashboardItemToItem(item, sourceEntity);
    }));
  }
  /**
   * @param {object} dashboardItem
   * @param {object} dashboardItem.summary
   * @param {object} dashboardItem.description
   * @param {string} dashboardItem.status
   * @param {module:nmodule/nss/rc/model/Entity} sourceEntity the source of this item
   * @returns {Promise.<module:nmodule/nss/rc/model/Item>}
   */


  function dashboardItemToItem(_ref7, sourceEntity) {
    var summary = _ref7.summary,
        description = _ref7.description,
        status = _ref7.status;
    var severity = tagToSeverity(status);
    return Promise.all([objectToLex(summary), objectToLex(description)]).then(function (_ref8) {
      var _ref9 = _slicedToArray(_ref8, 2),
          summary = _ref9[0],
          description = _ref9[1];

      return new Item({
        summary: summary,
        description: description,
        sourceEntity: sourceEntity,
        severity: severity
      });
    });
  }
  /**
   * @param {string} tag a tag from `baja:SecurityItemStatus`
   * @returns {module:nmodule/nss/rc/model/Severity}
   */


  function tagToSeverity(tag) {
    var en = baja.$('baja:SecurityItemStatus').get(tag);
    return new Severity({
      name: tag,
      displayName: en.getDisplayTag(),
      priority: en.getOrdinal(),
      icon: [nssLex.get(tag + '.icon')]
    });
  }
  /**
   * @param {object} params
   * @param {string} params.lexiconKey
   * @param {Array} params.arguments
   * @returns {Promise.<string>}
   */


  function objectToLex(_ref10) {
    var lexiconKey = _ref10.lexiconKey,
        _ref10$arguments = _ref10.arguments,
        args = _ref10$arguments === void 0 ? [] : _ref10$arguments;

    var _lexiconKey$split = lexiconKey.split(':'),
        _lexiconKey$split2 = _slicedToArray(_lexiconKey$split, 2),
        module = _lexiconKey$split2[0],
        key = _lexiconKey$split2[1];

    return Promise.all([lex.module(module), Promise.all(args.map(lexArgToString))]).then(function (_ref11) {
      var _ref12 = _slicedToArray(_ref11, 2),
          lex = _ref12[0],
          args = _ref12[1];

      return lex.get({
        key: key,
        args: args,
        def: key
      });
    });
  }
  /**
   * @param {object} lexArg
   * @param {string} [type='baja:String'] lexArg.type
   * @param {string} lexArg.value
   * @returns {Promise.<string>}
   */


  function lexArgToString(_ref13) {
    var _ref13$type = _ref13.type,
        type = _ref13$type === void 0 ? 'baja:String' : _ref13$type,
        value = _ref13.value;
    return baja.importTypes([type]).then(function () {
      return baja.$(type).decodeAsync(value);
    }).then(function (val) {
      return val.toString({});
    });
  }
  /**
   * @param {module:nmodule/nss/rc/model/ItemCollection} coll1
   * @param {module:nmodule/nss/rc/model/ItemCollection} coll2
   * @returns {number}
   */


  function byMaxSeverity(coll1, coll2) {
    var maxSeverity1 = coll1.getMaxSeverity();
    var maxSeverity2 = coll2.getMaxSeverity();

    if (maxSeverity1 && maxSeverity2) {
      var priority1 = maxSeverity1.getPriority();
      var priority2 = maxSeverity2.getPriority();
      return priority2 - priority1;
    } else if (maxSeverity1) {
      return -1;
    } else if (maxSeverity2) {
      return 1;
    }

    return 0;
  }

  return exports;
});
