function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/rpc/SystemDashboardService
 */
define(['nmodule/js/rc/tinyevents/tinyevents', 'nmodule/nss/rc/rpc/rpc'], function (tinyevents, rpc) {
  'use strict';
  /**
   * @class
   * @alias module:nmodule/nss/rc/rpc/SystemDashboardService
   * @implements module:nmodule/nss/rc/rpc/rpc.IDashboardService
   * @mixes tinyevents
   */

  return /*#__PURE__*/function () {
    function SystemDashboardService() {
      _classCallCheck(this, SystemDashboardService);

      tinyevents(this);
    }

    _createClass(SystemDashboardService, [{
      key: "getSourceCollection",
      value: function getSourceCollection(ord) {
        return rpc.getSystemDataAll(ord);
      }
    }, {
      key: "getItemCollection",
      value: function getItemCollection(ord, name, timestamp) {
        var _this = this;

        return rpc.getSystemDataSingle(ord, name, timestamp).then(function (itemCollection) {
          _this.emit('itemCollectionUpdated', itemCollection);

          return itemCollection;
        });
      }
    }, {
      key: "requestRefresh",
      value: function requestRefresh(ord, name) {
        return rpc.refreshSystemSingle(ord, name);
      }
    }, {
      key: "onItemCollectionUpdated",
      value: function onItemCollectionUpdated(cb) {
        this.on('itemCollectionUpdated', cb);
      }
    }]);

    return SystemDashboardService;
  }();
});
