function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/model/SourceCollection
 */
define(['nmodule/nss/rc/model/Entity', 'nmodule/nss/rc/model/Item', 'nmodule/nss/rc/model/ItemCollection', 'nmodule/nss/rc/util/securityDashboardUtil', 'lex!nss'], function (Entity, Item, ItemCollection, securityDashboardUtil, lexs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      nssLex = _lexs[0];
  /**
   * Collection of all items in a dashboard, from all sources. Items will be
   * organized by source into an array of ItemCollections.
   *
   * @class
   * @alias module:nmodule/nss/rc/model/SourceCollection
   * @param {object} params
   * @param {module:nmodule/nss/rc/model/Entity} params.sourceEntity source entity for source collection
   * @param {module:nmodule/nss/rc/model/ItemCollection[]} [params.itemCollections=[]] - array of item collections, default will be an empty array
   * @param {Date | null} [params.timestamp=null] should be null if generated from a station; returns Date if generated from a supervisor rollup
   * @throws {Error} if sourceEntity is missing or itemCollection is not valid
   */


  return /*#__PURE__*/function () {
    function SourceCollection() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          sourceEntity = _ref.sourceEntity,
          _ref$itemCollections = _ref.itemCollections,
          itemCollections = _ref$itemCollections === void 0 ? [] : _ref$itemCollections,
          _ref$timestamp = _ref.timestamp,
          timestamp = _ref$timestamp === void 0 ? null : _ref$timestamp;

      _classCallCheck(this, SourceCollection);

      if (!(sourceEntity instanceof Entity)) {
        throw new Error(nssLex.get('SecurityDashboardView.sourceCollection.entity.error'));
      }

      if (!isValidItemCollection(itemCollections)) {
        throw new Error(nssLex.get('SecurityDashboardView.sourceCollection.itemCollection.error'));
      }

      if (!(timestamp === null || timestamp instanceof Date)) {
        throw new Error(nssLex.get('SecurityDashboardView.itemCollection.date.invalid'));
      }

      this.$timestamp = timestamp;
      this.$sourceEntity = sourceEntity;
      this.$itemCollections = itemCollections || [];
    }
    /**
     * @returns {Date} Date at origin.
     */


    _createClass(SourceCollection, [{
      key: "getTimestamp",
      value: function getTimestamp() {
        return this.$timestamp;
      }
      /**
       * @returns {module:nmodule/nss/rc/model/Entity} source Entity of the source item collection
       * e.g. station or supervisor
       */

    }, {
      key: "getSourceEntity",
      value: function getSourceEntity() {
        return this.$sourceEntity;
      }
      /**
       * @returns {module:nmodule/nss/rc/model/ItemCollection[]} array of item collections
       */

    }, {
      key: "getItemCollections",
      value: function getItemCollections() {
        return this.$itemCollections.slice();
      }
      /**
       * @param {string} ord ORD of the item collection which is required
       * @returns {module:nmodule/nss/rc/model/ItemCollection | null} Item collection with the matching source ord
       */

    }, {
      key: "getItemCollection",
      value: function getItemCollection(ord) {
        var resultCollection = null;

        for (var i = 0; i < this.$itemCollections.length; i++) {
          if (this.$itemCollections[i].getSourceEntity().getOrd() === ord) {
            resultCollection = this.$itemCollections[i];
          }
        }

        return resultCollection;
      }
      /**
       * Update an item collection
       * 
       * @param {module:nmodule/nss/rc/model/ItemCollection} itemCollection 
       */

    }, {
      key: "updateItemCollection",
      value: function updateItemCollection(itemCollection) {
        for (var i = 0; i < this.$itemCollections.length; i++) {
          if (this.$itemCollections[i].getSourceEntity().equals(itemCollection.getSourceEntity())) {
            this.$itemCollections[i] = itemCollection;
          }
        }
      }
      /**
       * @returns {number} total count of items in all the item collections
       */

    }, {
      key: "getItemCount",
      value: function getItemCount() {
        var totalItemCountInCollection = 0;

        for (var i = 0; i < this.$itemCollections.length; i++) {
          totalItemCountInCollection = totalItemCountInCollection + this.$itemCollections[i].getItemCount();
        }

        return totalItemCountInCollection;
      }
      /**
       * @returns {Object[]} Array of objects with severity and counts from all the item collections
       */

    }, {
      key: "getCountsBySeverity",
      value: function getCountsBySeverity() {
        var itemCollections = this.$itemCollections;
        var countsBySeverityObjects = {},
            countsBySeverityArray = [];
        itemCollections.forEach(function (itemCollection) {
          itemCollection.getCountsBySeverity().forEach(function (countsBySeverityInCollection) {
            var severity = countsBySeverityInCollection.severity;
            var severityName = severity.getName();
            var severityCount = countsBySeverityInCollection.count;

            if (countsBySeverityObjects[severityName]) {
              countsBySeverityObjects[severityName].count += severityCount;
            } else {
              countsBySeverityObjects[severityName] = {
                severity: severity,
                count: severityCount
              };
              countsBySeverityArray.push(countsBySeverityObjects[severityName]);
            }
          });
        });
        return sortCountsBySeverityByPriority(countsBySeverityArray);
      }
    }]);

    return SourceCollection;
  }();
  /**
   * @param {module:nmodule/nss/rc/model/ItemCollection[]} itemCollectionList is list of items of type Item
   * @returns {boolean} true if itemCollection is valid and false if invalid
   */

  function isValidItemCollection(itemCollectionList) {
    if (itemCollectionList) {
      if (Array.isArray(itemCollectionList)) {
        return itemCollectionList.every(function (itemCollection) {
          return itemCollection instanceof ItemCollection;
        });
      } else {
        return false;
      }
    }

    return true;
  }
  /**
   * Sorts the countsBySeverityObject from highest to lowest priority.
   * @static
   * @param {Object[]} countsBySeverityObject  is an array of objects of severity and count
   * @returns {Object[]} sorted severityObjects by priority
   */


  function sortCountsBySeverityByPriority(countsBySeverityObject) {
    return countsBySeverityObject.sort(function (severity1, severity2) {
      return severity2.severity.getPriority() - severity1.severity.getPriority();
    });
  }
});
